/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums.invest;

import java.util.ArrayList;
import java.util.List;

public enum InvCaseProcessEnum {
    EJE("0", "EJE"),
    EIT("6", "EIT"),
    EICA("7", "EICA"),
    ECF("8", "ECF"),
    EOE("9", "EOE"),
    EOther("10", "EOther"),
    ADJ("1", "ADJ"),
    CADJ("2", "CADJ"),
    CCADJ("3", "CCADJ"),
    DEJE("4", "DEJE"),
    DADJ("5", "DADJ"),
    ERADJ("11", "ERAdj"),
    RADJ("12", "RAdj");

    private String index;
    private String number;

    private InvCaseProcessEnum(String index, String number) {
        this.index = index;
        this.number = number;
    }

    public static String getNumber(String index) {
        for (InvCaseProcessEnum value : InvCaseProcessEnum.values()) {
            if (!value.index.equals(index)) continue;
            return value.number;
        }
        return InvCaseProcessEnum.EJE.number;
    }

    public static String getIndex(String number) {
        for (InvCaseProcessEnum value : InvCaseProcessEnum.values()) {
            if (!value.number.equals(number)) continue;
            return value.index;
        }
        return InvCaseProcessEnum.EJE.index;
    }

    public static List<String> getInvChangeCaseNumber() {
        ArrayList<String> list = new ArrayList<String>(16);
        for (InvCaseProcessEnum value : InvCaseProcessEnum.values()) {
            if ("ERAdj".equals(value.number) || "RAdj".equals(value.number)) continue;
            list.add(value.number);
        }
        return list;
    }

    public static List<String> getInvNumber() {
        ArrayList<String> list = new ArrayList<String>(16);
        for (InvCaseProcessEnum value : InvCaseProcessEnum.values()) {
            if ("DADJ".equals(value.number) || "DEJE".equals(value.number) || "RAdj".equals(value.number)) continue;
            list.add(value.number);
        }
        return list;
    }

    public String getIndex() {
        return this.index;
    }

    public String getNumber() {
        return this.number;
    }
}

