/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums.invest;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum InvDateType {
    PeriodBegin("1", new MultiLangEnumBridge("\u5f53\u671f\u671f\u521d", "InvDateType_0", "fi-bcm-common")),
    PeriodEnd("2", new MultiLangEnumBridge("\u5f53\u671f\u671f\u672b", "InvDateType_1", "fi-bcm-common")),
    BeginYear("3", new MultiLangEnumBridge("\u5f53\u5e74\u5e74\u521d", "InvDateType_2", "fi-bcm-common")),
    SignedDate("4", new MultiLangEnumBridge("\u6307\u5b9a\u65e5\u671f", "InvDateType_3", "fi-bcm-common")),
    None("5", new MultiLangEnumBridge("\u4e0d\u9650", "InvDateType_4", "fi-bcm-common")),
    CurPeriod("6", new MultiLangEnumBridge("\u672c\u671f", "InvDateType_5", "fi-bcm-common")),
    CurYear("7", new MultiLangEnumBridge("\u672c\u5e74", "InvDateType_6", "fi-bcm-common")),
    Total("8", new MultiLangEnumBridge("\u7d2f\u8ba1", "InvDateType_7", "fi-bcm-common"));

    private String type;
    private MultiLangEnumBridge desc;

    private InvDateType(String type, MultiLangEnumBridge desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc.loadKDString();
    }

    public static String getNumberByType(String type) {
        Optional<InvDateType> matched = Arrays.stream(InvDateType.values()).filter(s -> Objects.equals(type, s.getType())).findFirst();
        if (matched.isPresent()) {
            return matched.get().name();
        }
        return "";
    }

    public static String getTypeByName(String name) {
        Optional<InvDateType> matched = Arrays.stream(InvDateType.values()).filter(s -> Objects.equals(name, s.name())).findFirst();
        if (matched.isPresent()) {
            return matched.get().getType();
        }
        return "";
    }

    public static String getNameByType(String type) {
        Optional<InvDateType> matched = Arrays.stream(InvDateType.values()).filter(s -> Objects.equals(type, s.getType())).findFirst();
        if (matched.isPresent()) {
            return matched.get().name();
        }
        return type;
    }
}

