/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums.invest;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum InvFetchType {
    EndScale("1", new MultiLangEnumBridge("\u671f\u672b\u80a1\u6bd4", "InvFetchType_0", "fi-bcm-common")),
    ChangeScale("2", new MultiLangEnumBridge("\u53d8\u52a8\u80a1\u6bd4", "InvFetchType_1", "fi-bcm-common")),
    BeginScale("3", new MultiLangEnumBridge("\u671f\u521d\u80a1\u6bd4", "InvFetchType_2", "fi-bcm-common")),
    InvestAmount("4", new MultiLangEnumBridge("\u6295\u8d44\u91d1\u989d", "InvFetchType_3", "fi-bcm-common")),
    ConfirmEndScale("5", new MultiLangEnumBridge("\u786e\u5b9a\u671f\u672b\u80a1\u6bd4", "InvFetchType_4", "fi-bcm-common")),
    ConfirmChangeScale("6", new MultiLangEnumBridge("\u786e\u5b9a\u53d8\u52a8\u80a1\u6bd4", "InvFetchType_5", "fi-bcm-common")),
    ConfirmBeginScale("7", new MultiLangEnumBridge("\u786e\u5b9a\u671f\u521d\u80a1\u6bd4", "InvFetchType_6", "fi-bcm-common"));

    private String type;
    private MultiLangEnumBridge desc;

    private InvFetchType(String type, MultiLangEnumBridge desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc.loadKDString();
    }

    public static String getNumberByType(String type) {
        Optional<InvFetchType> matched = Arrays.stream(InvFetchType.values()).filter(s -> Objects.equals(type, s.getType())).findFirst();
        if (matched.isPresent()) {
            return matched.get().name();
        }
        return "";
    }

    public static String getTypeByName(String name) {
        Optional<InvFetchType> matched = Arrays.stream(InvFetchType.values()).filter(s -> Objects.equals(name, s.name())).findFirst();
        if (matched.isPresent()) {
            return matched.get().getType();
        }
        return "";
    }

    public static String getDescByName(String name) {
        Optional<InvFetchType> matched = Arrays.stream(InvFetchType.values()).filter(s -> Objects.equals(name, s.name())).findFirst();
        if (matched.isPresent()) {
            return matched.get().getDesc();
        }
        return "";
    }
}

