/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums.rule;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.bcm.common.enums.ReportStatusEnum;

public enum BizRuleReportStatusEnum {
    U("U"),
    I("I"),
    C("C"),
    S("S");

    private String status;

    private BizRuleReportStatusEnum(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public static Set<String> getAllStatus() {
        return Arrays.stream(BizRuleReportStatusEnum.values()).map(BizRuleReportStatusEnum::getStatus).collect(Collectors.toSet());
    }

    public static ReportStatusEnum getReportStatus(String code) {
        ReportStatusEnum reportStatus;
        switch (code) {
            case "I": {
                reportStatus = ReportStatusEnum.WEAVING;
                break;
            }
            case "C": {
                reportStatus = ReportStatusEnum.COMPLETE;
                break;
            }
            case "S": {
                reportStatus = ReportStatusEnum.COMMIT;
                break;
            }
            default: {
                reportStatus = ReportStatusEnum.UNWEAVE;
            }
        }
        return reportStatus;
    }

    public static String transReportStatus(ReportStatusEnum reportStatus) {
        String status;
        switch (reportStatus) {
            case WEAVING: 
            case BACK: {
                status = BizRuleReportStatusEnum.I.status;
                break;
            }
            case COMPLETE: {
                status = BizRuleReportStatusEnum.C.status;
                break;
            }
            case COMMIT: {
                status = BizRuleReportStatusEnum.S.status;
                break;
            }
            default: {
                status = BizRuleReportStatusEnum.U.status;
            }
        }
        return status;
    }
}

