/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums.rule;

import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum LinkSymbolEnum {
    EMPTY("0", "", ""),
    AND("1", new MultiLangEnumBridge("\u4e14", "LinkSymbolEnum_0", "fi-bcm-common"), " && ", "and"),
    OR("2", new MultiLangEnumBridge("\u6216", "LinkSymbolEnum_1", "fi-bcm-common"), " || ", "or");

    private String value;
    private MultiLangEnumBridge description;
    private String jsScript;
    private String engDes;

    private LinkSymbolEnum(String value, String jsScript, String engDes) {
        this.value = value;
        this.jsScript = jsScript;
        this.engDes = engDes;
    }

    private LinkSymbolEnum(String value, MultiLangEnumBridge description, String jsScript, String engDes) {
        this.value = value;
        this.description = description;
        this.jsScript = jsScript;
        this.engDes = engDes;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description.loadKDString();
    }

    public String getJsScript() {
        return this.jsScript;
    }

    public String getEngDes() {
        return this.engDes;
    }

    public static LinkSymbolEnum getEnumByValue(String value) {
        LinkSymbolEnum[] linkSymbolEnums;
        for (LinkSymbolEnum linkSymbolEnum : linkSymbolEnums = LinkSymbolEnum.values()) {
            if (!linkSymbolEnum.getValue().equals(value)) continue;
            return linkSymbolEnum;
        }
        return null;
    }

    public static LinkSymbolEnum getEnumByName(String value) {
        LinkSymbolEnum[] linkSymbolEnums;
        for (LinkSymbolEnum linkSymbolEnum : linkSymbolEnums = LinkSymbolEnum.values()) {
            if (!linkSymbolEnum.getDescription().equals(value)) continue;
            return linkSymbolEnum;
        }
        return null;
    }

    public static LinkSymbolEnum getEnumByEngDes(String engDes) {
        LinkSymbolEnum[] linkSymbolEnums;
        for (LinkSymbolEnum linkSymbolEnum : linkSymbolEnums = LinkSymbolEnum.values()) {
            if (!linkSymbolEnum.getEngDes().equals(engDes)) continue;
            return linkSymbolEnum;
        }
        return null;
    }
}

