/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.enums.workpaper;

import kd.bos.dataentity.resource.ResManager;

public enum DimensionMemberDisplayTypeEnum {
    NUMBER(1, DimensionMemberDisplayTypeEnum.showNumber()),
    NAME(2, DimensionMemberDisplayTypeEnum.showName()),
    SIMPLE(3, DimensionMemberDisplayTypeEnum.showSimple()),
    NUMBERANDNAME(4, DimensionMemberDisplayTypeEnum.showNumberAndname()),
    NUMBERANDSIMPLE(5, DimensionMemberDisplayTypeEnum.showNumberAndSimple());

    private int index;
    private String text;

    private DimensionMemberDisplayTypeEnum(int idx, String text) {
        this.text = text;
        this.index = idx;
    }

    public int getIndex() {
        return this.index;
    }

    public String getText() {
        String name = DimensionMemberDisplayTypeEnum.showNumberAndname();
        switch (this.index) {
            case 1: {
                name = DimensionMemberDisplayTypeEnum.showNumber();
                break;
            }
            case 2: {
                name = DimensionMemberDisplayTypeEnum.showName();
                break;
            }
            case 3: {
                name = DimensionMemberDisplayTypeEnum.showSimple();
                break;
            }
            case 4: {
                name = DimensionMemberDisplayTypeEnum.showNumberAndname();
                break;
            }
            case 5: {
                name = DimensionMemberDisplayTypeEnum.showNumberAndSimple();
            }
        }
        return name;
    }

    public static DimensionMemberDisplayTypeEnum getEnumByItemKey(String key) {
        DimensionMemberDisplayTypeEnum displayTypeEnum;
        switch (key) {
            case "btn_number": 
            case "btn_row_number": {
                displayTypeEnum = NUMBER;
                break;
            }
            case "btn_name": 
            case "btn_row_name": {
                displayTypeEnum = NAME;
                break;
            }
            case "btn_simple": {
                displayTypeEnum = SIMPLE;
                break;
            }
            case "btn_numsimple": {
                displayTypeEnum = NUMBERANDSIMPLE;
                break;
            }
            default: {
                displayTypeEnum = NUMBERANDNAME;
            }
        }
        return displayTypeEnum;
    }

    public static DimensionMemberDisplayTypeEnum getEnumByIndex(int idx) {
        for (DimensionMemberDisplayTypeEnum value : DimensionMemberDisplayTypeEnum.values()) {
            if (value.getIndex() != idx) continue;
            return value;
        }
        return NUMBERANDNAME;
    }

    private static String showNumber() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u663e\u793a\u6837\u5f0f\uff1a\u7f16\u7801", (String)"DimensionMemberDisplayTypeEnum_0", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String showName() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u663e\u793a\u6837\u5f0f\uff1a\u540d\u79f0", (String)"DimensionMemberDisplayTypeEnum_1", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String showSimple() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u663e\u793a\u6837\u5f0f\uff1a\u7b80\u79f0", (String)"DimensionMemberDisplayTypeEnum_2", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String showNumberAndname() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u663e\u793a\u6837\u5f0f\uff1a\u7f16\u7801+\u540d\u79f0", (String)"DimensionMemberDisplayTypeEnum_3", (String)"fi-bcm-common", (Object[])new Object[0]);
    }

    private static String showNumberAndSimple() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u663e\u793a\u6837\u5f0f\uff1a\u7f16\u7801+\u7b80\u79f0", (String)"DimensionMemberDisplayTypeEnum_4", (String)"fi-bcm-common", (Object[])new Object[0]);
    }
}

