/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import kd.fi.bcm.common.graph.DGraph;
import kd.fi.bcm.common.graph.Edge;

public class ListDGraph<V>
implements DGraph<V> {
    private LinkedList<VE> mVEList = new LinkedList();

    @Override
    public int add(V v) {
        int index = -1;
        if (v != null) {
            VE list = new VE(v);
            this.mVEList.add(list);
            index = this.mVEList.indexOf(list);
        }
        return index;
    }

    @Override
    public void add(Edge<V> e) {
        VE ve;
        if (e != null && (ve = this.getVE(e.getSource())) != null) {
            ve.addEdge(e);
        }
    }

    @Override
    public V remove(V v) {
        Object ret = null;
        VE ve = this.removeVE(v);
        if (ve != null) {
            ret = ve.v;
        }
        this.removeRelateEdge(v);
        return (V)ret;
    }

    @Override
    public Edge<V> remove(Edge<V> e) {
        VE ve;
        Edge ret = null;
        if (e != null && (ve = this.getVE(e.getSource())) != null) {
            ret = ve.removeEdge(e.getDest());
        }
        return ret;
    }

    @Override
    public V get(int index) {
        VE ve;
        Object ret = null;
        if (index >= 0 && index < this.mVEList.size() && (ve = this.mVEList.get(index)) != null) {
            ret = ve.v;
        }
        return (V)ret;
    }

    @Override
    public Edge<V> get(int src, int dest) {
        VE ve;
        Edge ret = null;
        V s = this.get(src);
        V d = this.get(dest);
        if (s != null && d != null && (ve = this.getVE(s)) != null) {
            ret = ve.getEdge(d);
        }
        return ret;
    }

    @Override
    public List<V> visit(V start, V end) {
        ArrayList<Object> mediumList = new ArrayList<Object>(10);
        VE startVe = this.getVE(start);
        if (startVe != null) {
            List startEdges = startVe.mEdgeList;
            for (int i = 0; i < startEdges.size(); ++i) {
                VE medium = this.getVE(((Edge)startEdges.get(i)).getDest());
                if (medium == null) continue;
                List mediumEdges = medium.mEdgeList;
                for (int j = 0; j < mediumEdges.size(); ++j) {
                    if (!((Edge)mediumEdges.get(j)).getDest().equals(end)) continue;
                    mediumList.add(medium.v);
                }
            }
        }
        return mediumList;
    }

    @Override
    public List<List<V>> visitAllRoad(V start, V end) {
        HashMap<Object, Integer> state = new HashMap<Object, Integer>();
        ArrayList<List<V>> mediumList = new ArrayList<List<V>>(10);
        VE startVe = this.getVE(start);
        VE endVe = this.getVE(end);
        if (startVe != null && endVe != null) {
            Stack<Object> stack = new Stack<Object>();
            stack.push(start);
            while (!stack.empty()) {
                Edge nextEdge;
                VE nextNode;
                VE top = this.getVE(stack.peek());
                if (top == null) continue;
                if (top.v.equals(end)) {
                    mediumList.add(new ArrayList(stack));
                    state.remove(stack.pop());
                    continue;
                }
                Integer nextIndex = (Integer)state.get(top.v);
                if (top.mEdgeList.size() == 0 || nextIndex != null && top.mEdgeList.size() == nextIndex.intValue()) {
                    state.remove(stack.pop());
                    continue;
                }
                if (nextIndex == null) {
                    nextIndex = 0;
                }
                if ((nextNode = this.getVE((nextEdge = (Edge)top.mEdgeList.get(nextIndex)).getDest())) != null) {
                    stack.push(nextNode.v);
                }
                state.put(top.v, nextIndex + 1);
            }
        }
        return mediumList;
    }

    private VE getVE(V v) {
        VE ret = null;
        if (v != null) {
            for (VE ve : this.mVEList) {
                if (ve.v == null || !v.equals(ve.v)) continue;
                ret = ve;
                break;
            }
        }
        return ret;
    }

    private VE removeVE(V v) {
        VE ret = null;
        if (v != null) {
            for (VE ve : this.mVEList) {
                if (ve.v == null || !v.equals(ve.v)) continue;
                ret = ve;
                this.mVEList.remove(ve);
                break;
            }
        }
        return ret;
    }

    private void removeRelateEdge(V v) {
        if (v != null) {
            for (VE ve : this.mVEList) {
                ve.removeEdge(v);
            }
        }
    }

    private boolean VinList(V v, Iterator<V> it) {
        boolean ret = false;
        if (v != null && it != null) {
            while (it.hasNext()) {
                V v_temp = it.next();
                if (v_temp == null || !v_temp.equals(v)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private class BFSIterator
    implements Iterator<V> {
        private List<V> mVisitList = new LinkedList();
        private Queue<V> mVQueue = new LinkedList();

        public BFSIterator(V root) {
            this.mVQueue.offer(root);
        }

        @Override
        public boolean hasNext() {
            return this.mVQueue.size() > 0;
        }

        @Override
        public V next() {
            Object v = this.mVQueue.poll();
            if (v != null) {
                VE ve = ListDGraph.this.getVE(v);
                if (ve != null) {
                    List list = ve.mEdgeList;
                    for (Edge edge : list) {
                        Object dest = edge.getDest();
                        if (ListDGraph.this.VinList(dest, this.mVisitList.iterator()) || ListDGraph.this.VinList(dest, this.mVQueue.iterator())) continue;
                        this.mVQueue.offer(dest);
                    }
                }
                this.mVisitList.add(v);
            }
            return v;
        }

        @Override
        public void remove() {
        }
    }

    private class VE {
        private V v;
        private List<Edge<V>> mEdgeList;

        public VE(V v) {
            this.v = v;
            this.mEdgeList = new LinkedList();
        }

        public String toString() {
            String ret = String.format("v : %s , list len : %s", this.v, this.mEdgeList.size());
            return ret;
        }

        public void addEdge(Edge<V> e) {
            if (this.getEdge(e.getDest()) == null) {
                this.mEdgeList.add(e);
            }
        }

        public Edge<V> getEdge(V dest) {
            Edge ret = null;
            if (dest != null) {
                for (Edge edge : this.mEdgeList) {
                    if (edge.getDest() == null || !dest.equals(edge.getDest())) continue;
                    ret = edge;
                    break;
                }
            }
            return ret;
        }

        public Edge<V> removeEdge(V dest) {
            Edge ret = null;
            if (dest != null) {
                for (Edge edge : this.mEdgeList) {
                    if (edge.getDest() == null || !dest.equals(edge.getDest())) continue;
                    ret = edge;
                    this.mEdgeList.remove(edge);
                    break;
                }
            }
            return ret;
        }
    }
}

