/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kd.fi.bcm.common.model.MessageInfo;
import kd.fi.bcm.common.model.MessageTypeEnum;

public class ResultBox {
    private String code;
    private final List<MessageInfo> messageList = new ArrayList<MessageInfo>();
    private final List<MessageInfo> successList = new ArrayList<MessageInfo>();
    private final List<MessageInfo> tipList = new ArrayList<MessageInfo>();
    private final List<MessageInfo> errorList = new ArrayList<MessageInfo>();
    private Object data;

    private ResultBox() {
    }

    public static ResultBox of() {
        return new ResultBox();
    }

    public void add(String message) {
        if (message != null) {
            this.add(MessageInfo.newOne(message));
        }
    }

    public void addError(String message) {
        if (message != null) {
            this.add(message, MessageTypeEnum.ERROR);
        }
    }

    public void addSuccess(String message) {
        if (message != null) {
            this.add(message, MessageTypeEnum.SUCCESS);
        }
    }

    public void addTip(String message) {
        if (message != null) {
            this.add(message, MessageTypeEnum.TIP);
        }
    }

    public void add(Supplier<String> supplier) {
        if (this.isSuccess()) {
            String str = supplier.get();
            this.add(str);
        }
    }

    public void addError(Supplier<String> supplier) {
        if (this.isSuccess()) {
            String str = supplier.get();
            this.addError(str);
        }
    }

    private void add(String message, MessageTypeEnum type) {
        this.add(MessageInfo.newOne(message, type));
    }

    private void add(MessageInfo messageInfo) {
        if (messageInfo != null) {
            MessageTypeEnum type = messageInfo.getType();
            if (MessageTypeEnum.SUCCESS == type) {
                this.successList.add(messageInfo);
            } else if (MessageTypeEnum.TIP == type) {
                this.tipList.add(messageInfo);
            } else if (MessageTypeEnum.ERROR == type) {
                this.errorList.add(messageInfo);
            }
            this.messageList.add(messageInfo);
        }
    }

    public void append(ResultBox result) {
        for (MessageInfo messageInfo : result.getMessageList()) {
            this.add(messageInfo);
        }
        this.setCode(result.getCode());
    }

    public void append(Supplier<ResultBox> supplier) {
        if (this.isSuccess()) {
            ResultBox resultInfo = supplier.get();
            this.append(resultInfo);
        }
    }

    public boolean isSuccess() {
        return this.errorList.isEmpty() && this.tipList.isEmpty();
    }

    public boolean isTip() {
        return this.errorList.isEmpty() && !this.tipList.isEmpty();
    }

    public boolean isError() {
        return !this.errorList.isEmpty();
    }

    public boolean isNotSuccess() {
        return !this.isSuccess();
    }

    public String getMessageText() {
        if (!this.errorList.isEmpty()) {
            return this.errorList.get(0).getMessage();
        }
        if (!this.tipList.isEmpty()) {
            return this.tipList.get(0).getMessage();
        }
        if (!this.successList.isEmpty()) {
            return this.successList.get(0).getMessage();
        }
        return "";
    }

    public List<MessageInfo> getMessageList() {
        return this.messageList;
    }

    public List<MessageInfo> getSuccessList() {
        return this.successList;
    }

    public List<MessageInfo> getTipList() {
        return this.tipList;
    }

    public List<MessageInfo> getErrorList() {
        return this.errorList;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public <T> T getData() {
        return (T)this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

