/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.mq;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.instance.Instance;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.mq.broadcast.Configure;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.mq.MQMessage;
import kd.fi.bcm.common.mq.MQMessageTypeEnum;

public class BroadcastMessagePublisher {
    private static final String CLASS_BROADCAST_NAME = "kd.fi.bcm.business.mq.consumer.BroadcastConsumerFacade";
    private static final String METHOD_BROADCAST_NAME = "onMessage";
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(true, BroadcastMessagePublisher.class);

    public static void publishBroadcastMessage(MQMessage msg) {
        BroadcastMessagePublisher.broadcastMessage(CLASS_BROADCAST_NAME, METHOD_BROADCAST_NAME, new Object[]{msg.genSendMQFormatMessage()});
    }

    public static void publishBroadcastMessageWithAppId(MQMessage msg) {
        Object[] message = new Object[]{msg.genSendMQFormatMessage()};
        BroadcastMessagePublisher.broadcastMessageWithApp("bcm", CLASS_BROADCAST_NAME, METHOD_BROADCAST_NAME, message);
        if (Instance.isAppSplit() && Instance.getAppIds() != null) {
            Set appIds = Arrays.stream(Instance.getAppIds()).collect(Collectors.toSet());
            if (!appIds.contains("di")) {
                BroadcastMessagePublisher.broadcastMessageWithApp("di", CLASS_BROADCAST_NAME, METHOD_BROADCAST_NAME, message);
            }
            if (!appIds.contains("bcm_calcnode")) {
                BroadcastMessagePublisher.broadcastMessageWithApp("bcm_calcnode", CLASS_BROADCAST_NAME, METHOD_BROADCAST_NAME, message);
            }
        }
    }

    private static void broadcastMessageWithApp(String appId, String className, String methodName, Object[] params) {
        if (Configure.getSupportBroadcastAppids().contains(appId)) {
            log.info(String.format("reloadDimensionCache broadcast message success. appId:%s", appId));
            BroadcastService.broadcastMessageWithApp((String)appId, (String)className, (String)methodName, (Object[])params);
        } else {
            log.error(String.format("reloadDimensionCache broadcast message error. appId:%s is not config", appId));
        }
    }

    private static void broadcastMessage(String className, String methodName, Object[] params) {
        BroadcastService.broadcastMessage((String)className, (String)methodName, (Object[])params);
    }

    public static void publishReloadDimCache(String modelNum, String dimNum, boolean isSchedule) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_Local_Cache_Reload);
        HashMap<String, Object> messageMap = new HashMap<String, Object>(16);
        messageMap.put("modelNum", modelNum);
        messageMap.put("dimNum", dimNum);
        messageMap.put("isSchedule", isSchedule);
        messageMap.put("accountId", RequestContext.get().getAccountId());
        messageMap.put("tenantId", RequestContext.get().getTenantId());
        msg.setSendMessage(messageMap);
        BroadcastMessagePublisher.publishBroadcastMessageWithAppId(msg);
    }
}

