/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.mq;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.common.auditlog.AuditLogESIndexStrategy;
import kd.fi.bcm.common.auditlog.LocalDateFormat;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.mq.MQMessage;
import kd.fi.bcm.common.mq.MQMessageTypeEnum;
import kd.fi.bcm.common.oplog.OpLogs;
import kd.fi.bcm.common.trace.TraceLogMsg;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class MQCommonPublisher {
    private static final Log LOG = LogFactory.getLog(MQCommonPublisher.class);
    public static final String MQ_REGION = "fi";
    public static final String MQ_QUEUE_NAME = "bcm_queue";
    public static final String MQ_QUEUE_DC = "bcm_datacollect";
    public static final String MQ_QUEUE_CALC = "bcm_calc_queue";
    public static final String MQ_QUEUE_DI = "di";
    public static final String MQ_QUEUE_TRACELOG = "bcm_tracelog";
    public static final String MQ_QUEUE_ADJUSTDIMOPERTRACELOG = "bcm_adjustdimopertracelog";
    public static final String MQ_QUEUE_INVTRACELOG = "bcm_invtracelog";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishMessage(MQMessage msg, boolean isTranscation, String quename) {
        try (MessagePublisher pub = null;){
            pub = MQFactory.get().createSimplePublisher(MQ_REGION, quename);
            if (isTranscation) {
                pub.publishInDbTranscation(null, (Object)msg.genSendMQFormatMessage());
            } else {
                pub.publish(msg.genSendMQFormatMessage());
            }
        }
    }

    public static void publishMessage(MQMessage msg, boolean isTranscation) {
        MQCommonPublisher.publishMessage(msg, isTranscation, MQ_QUEUE_NAME);
    }

    public static void publishAuditSummaryLog(String indexName, Map<String, Object> dataMap) {
        LOG.debug("start send audit_log message, index: " + indexName);
        if (StringUtils.isEmpty(indexName)) {
            throw new IllegalArgumentException("param 'indexName' is empty");
        }
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_Audit_Summary_Log);
        HashMap<String, Object> messageBody = new HashMap<String, Object>(4);
        messageBody.put("_esindex", indexName);
        messageBody.put("content", JacksonUtils.toJson(dataMap, new LocalDateFormat()));
        msg.setSendMessage(messageBody);
        MQCommonPublisher.publishMessage(msg, false);
        LOG.debug("audit_log send message success, index: " + indexName);
    }

    public static void publishAdjustDimOperationLog(long modelId, long sceneId, long yearId, long periodId, AdjustOperTypeEnum operTypeEnum, Map<String, Object> params) {
        Map logQueueMap = (Map)params.get("logQueueMap");
        if (logQueueMap != null && !logQueueMap.keySet().isEmpty()) {
            MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_AdjustDimOperationLogMsg);
            HashMap<String, Object> messageBody = new HashMap<String, Object>(16);
            messageBody.put("modelId", modelId);
            messageBody.put("sceneId", sceneId);
            messageBody.put("yearId", yearId);
            messageBody.put("periodId", periodId);
            messageBody.put("opertype", operTypeEnum.getValue());
            messageBody.put("dimKeys", params.get("dimKeys"));
            messageBody.put("specialSourceKey", params.get("specialSourceKey"));
            messageBody.put("content", ObjectSerialUtil.toByteSerialized(logQueueMap));
            messageBody.put("traceId", RequestContext.get().getTraceId());
            messageBody.put("createTime", TimeServiceHelper.getTimeStamp());
            msg.setSendMessage(messageBody);
            MQCommonPublisher.publishMessage(msg, false, MQ_QUEUE_ADJUSTDIMOPERTRACELOG);
        }
    }

    public static void publishInvFormulaTraceLog(String logType, long modelId, long sceneId, long yearId, long periodId, long entityId, long tempId, List<Map<String, Object>> detailLogMsgList) {
        if (!CollectionUtil.isEmpty(detailLogMsgList)) {
            MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_InvFormulaTraceLog);
            HashMap<String, Object> messageBody = new HashMap<String, Object>(16);
            messageBody.put("logType", logType);
            messageBody.put("modelId", modelId);
            messageBody.put("sceneId", sceneId);
            messageBody.put("yearId", yearId);
            messageBody.put("periodId", periodId);
            messageBody.put("orgunit", entityId);
            messageBody.put("userId", RequestContext.getOrCreate().getCurrUserId());
            messageBody.put("createTime", TimeServiceHelper.getTimeStamp());
            messageBody.put("tempId", tempId);
            messageBody.put("content", ObjectSerialUtil.toByteSerialized(detailLogMsgList));
            msg.setSendMessage(messageBody);
            MQCommonPublisher.publishMessage(msg, false, MQ_QUEUE_INVTRACELOG);
        }
    }

    public static void publishOpEventLog(OpLogs.OpEventLog opEventLog) {
        if (StringUtils.isEmpty(opEventLog.getModelNumber())) {
            LOG.warn("op_log not found model number", (Object)JacksonUtils.toJson(opEventLog));
            return;
        }
        String indexName = AuditLogESIndexStrategy.buildOpLogIndexName(opEventLog.getModelNumber());
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_Op_event_Log);
        HashMap<String, Object> messageBody = new HashMap<String, Object>(4);
        messageBody.put("_esindex", indexName);
        messageBody.put("content", JacksonUtils.toJson(opEventLog, new LocalDateFormat()));
        msg.setSendMessage(messageBody);
        MQCommonPublisher.publishMessage(msg, false);
    }

    public static void publishDataCollect(List<Long> orgId, String ctx) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_DataCollect);
        msg.setSendMessage(new HashMap<String, Object>(1));
        msg.getSendMessage().put("dataCollectCtx", ctx);
        msg.getSendMessage().put("dataCollectOrg", orgId);
        MQCommonPublisher.publishMessage(msg, false, MQ_QUEUE_DC);
    }

    public static void publishDataTraceInfo(String ctx, Long modelId) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_DataTrace_DataFrom);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataFromList", ctx);
        map.put("modelId", modelId);
        msg.setSendMessage(map);
        MQCommonPublisher.publishMessage(msg, false);
    }

    public static void publishDataIntegration(String intEntity, boolean isEntryIntergate, boolean isUseSpecialService) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_Integration);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("intEntity", intEntity);
        map.put("isEntryIntergate", isEntryIntergate);
        msg.setSendMessage(map);
        if (isUseSpecialService) {
            MQCommonPublisher.publishMessage(msg, false, MQ_QUEUE_CALC);
        } else {
            MQCommonPublisher.publishMessage(msg, false);
        }
    }

    public static void publishDIDataIntegration(String intEntity, boolean isUseSpecialService) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_DIIntegration);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("intEntity", intEntity);
        msg.setSendMessage(map);
        MQCommonPublisher.publishMessage(msg, false, MQ_QUEUE_DI);
    }

    public static void publishDIDataIntegrationBat(String mqMap) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_DIIntegrationBat);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mqMap", mqMap);
        msg.setSendMessage(map);
        MQCommonPublisher.publishMessage(msg, false, MQ_QUEUE_DI);
    }

    public static void publishTraceLog(TraceLogMsg traceLogMsg) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_TraceLogMsg);
        msg.setSendMessage(new HashMap<String, Object>(1));
        msg.getSendMessage().put("tracelogmsg", ObjectSerialUtil.toByteSerialized(traceLogMsg));
        MQCommonPublisher.publishMessage(msg, false, MQ_QUEUE_TRACELOG);
    }
}

