/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.mq;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import kd.bos.mq.MessageAcker;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class MQMsServiceMessage
implements Serializable {
    private String consumerType;
    private String cloudId;
    private String appId;
    private String serviceName;
    private String methodName;
    private Map<String, Object> paras;

    public static MQMsServiceMessage cast(String json) {
        try {
            if (json.startsWith("#gzip#")) {
                json = ObjectSerialUtil.uncompress4GZip(json);
            }
            return (MQMsServiceMessage)JSONUtils.cast((String)json, MQMsServiceMessage.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String genSendMQFormatMessage() {
        try {
            return ObjectSerialUtil.compress4GZip(JSONUtils.toString((Object)this));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onMessage(String messageId, boolean resend, MessageAcker messageAcker) {
        DispatchServiceHelper.invokeBizService((String)this.cloudId, (String)this.appId, (String)this.serviceName, (String)this.methodName, (Object[])new Object[]{this.paras});
    }

    public String getConsumerType() {
        return this.consumerType;
    }

    public void setConsumerType(String consumerType) {
        this.consumerType = consumerType;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Map<String, Object> getParas() {
        return this.paras;
    }

    public void setParas(Map<String, Object> paras) {
        this.paras = paras;
    }
}

