/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.msservice;

import java.io.IOException;
import java.util.List;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.msservice.param.ConvertParam;

public class MsServiceHelper {
    public static <T> T invokeService(String cloudId, String appId, String serviceName, String methodName, Object ... paras) {
        return (T)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])paras);
    }

    private static String invokeBizService(String serviceName, String methodName, Object ... params) {
        return (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm_calcnode", (String)serviceName, (String)methodName, (Object[])params);
    }

    public static <T> T invokeBizServiceByGivenClassPath(String cloudId, String appId, String clazzPath, String serviceName, String methodName, Object ... paras) {
        try (TraceSpan span = Tracer.create((String)(appId + "." + serviceName), (String)methodName);){
            DispatchService service = MsServiceHelper.serviceLookup(appId);
            String factory = clazzPath;
            Object object = service.invoke(factory, serviceName, methodName, paras);
            return (T)object;
        }
    }

    private static DispatchService serviceLookup(String appId) {
        DispatchService service = null;
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
        return service;
    }

    public static List<String> invokeConvertService(ConvertParam param) {
        String result = MsServiceHelper.invokeBizService("ConvertService", "convert", param.toString());
        return MsServiceHelper.castJson2Object(result, List.class);
    }

    public static void invokeMcDataCollectService(String ctx) {
        MsServiceHelper.invokeBizService("McDataCollectMsService", "mcDataCollect", ctx);
    }

    public static String invokeMcCalculateService(String ctx) {
        return MsServiceHelper.invokeBizService("McCalculateMsService", "mcCalculate", ctx);
    }

    public static String invokeMcConvertService(String ctx) {
        return MsServiceHelper.invokeBizService("McConvertMsService", "mcConvert", ctx);
    }

    public static void invokeCslService(String ctx, String orgNode) {
        MsServiceHelper.invokeBizService("CslService", "cslCalculate", ctx, orgNode);
    }

    public static void invokeInvalidateOutlineCache(String processId) {
        MsServiceHelper.invokeBizService("CslService", "invalidateAllCurrOutlineCache", processId);
    }

    private static <T> T castJson2Object(String json, Class<T> clazz) {
        try {
            return (T)JSONUtils.cast((String)json, clazz);
        }
        catch (IOException e) {
            throw new KDBizException(new ErrorCode("fi.bcm.msJsonCastErr", "parse Json %s to %s fail,cause:%s"), new Object[]{json, clazz.getName(), e.getMessage()});
        }
    }

    public static void invalidateAllCurrOutlineCache(String processId) {
        GlobalCacheServiceHelper.invalidateAllCurrentCache(processId);
    }

    public static String invokeMergeChkService(String ctx) {
        return MsServiceHelper.invokeBizService("MergeChkService", "doCheck", ctx);
    }
}

