/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.oplog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import kd.bos.context.RequestContext;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class OpLogs {

    public static class OpEventLog {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="_id")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String pkId;
        private String id;
        private String eventProxyType;
        private String appId;
        private String modelNumber;
        private Integer opCategory;
        private String sourceKey;
        private String subSourceKey;
        private Date startTime;
        private Date endTime;
        private OpStatus status;
        private String errMsg;
        private List<EventPhaseLog> phases = new ArrayList<EventPhaseLog>(2);
        private String opUserId;
        private String userIP;
        private Integer cost;
        private transient Queue<Class<?>> validatorQueue = new LinkedList();

        public OpEventLog() {
        }

        public OpEventLog(String id, String eventProxyType, Date startTime, RequestContext requestContext) {
            this.id = id;
            this.eventProxyType = eventProxyType;
            this.startTime = startTime;
            this.opUserId = requestContext.getUserId();
            String loginIP = requestContext.getLoginIP();
            this.userIP = "[0:0:0:0:0:0:0:1]".equals(loginIP) ? "127.0.0.1" : loginIP;
        }

        public static OpEventLog buildCustomLog(String modelNumber, String sourceKey, String subSourceKey, int opCategory, Date startTime, Date endTime) {
            OpEventLog eventLog = new OpEventLog(GlobalIdUtil.genStringId(), "Custom", startTime, RequestContext.get());
            eventLog.setAppId("cm");
            eventLog.setModelNumber(modelNumber);
            eventLog.setSourceKey(sourceKey);
            eventLog.setSubSourceKey(subSourceKey);
            eventLog.setOpCategory(opCategory);
            eventLog.setEndTime(endTime);
            eventLog.setStatus(OpStatus.DONE);
            return eventLog;
        }

        public String getPkId() {
            return this.pkId;
        }

        public void setPkId(String pkId) {
            this.pkId = pkId;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
            if (null != endTime && null != this.startTime) {
                this.setCost(Integer.valueOf(String.valueOf(this.endTime.getTime() - this.startTime.getTime())));
            }
        }

        public Integer getOpCategory() {
            return this.opCategory;
        }

        public void setOpCategory(Integer opCategory) {
            this.opCategory = opCategory;
        }

        public OpStatus getStatus() {
            return this.status;
        }

        public void setStatus(OpStatus status) {
            this.status = status;
        }

        public String getOpUserId() {
            return this.opUserId;
        }

        public void setOpUserId(String opUserId) {
            this.opUserId = opUserId;
        }

        public String getUserIP() {
            return this.userIP;
        }

        public void setUserIP(String userIP) {
            this.userIP = userIP;
        }

        public Integer getCost() {
            return this.cost;
        }

        public void setCost(Integer cost) {
            this.cost = cost;
        }

        public List<EventPhaseLog> getPhases() {
            return this.phases;
        }

        public void setPhases(List<EventPhaseLog> phases) {
            this.phases = phases;
        }

        public String getSourceKey() {
            return this.sourceKey;
        }

        public void setSourceKey(String sourceKey) {
            this.sourceKey = sourceKey;
        }

        public String getSubSourceKey() {
            return this.subSourceKey;
        }

        public void setSubSourceKey(String subSourceKey) {
            this.subSourceKey = subSourceKey;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        public String getEventProxyType() {
            return this.eventProxyType;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getModelNumber() {
            return this.modelNumber;
        }

        public void setModelNumber(String modelNumber) {
            this.modelNumber = modelNumber;
        }

        @JsonIgnore
        @Transient
        public void doneOneValidate(Class<?> validatorClazz) {
            this.validatorQueue.offer(validatorClazz);
        }

        @JsonIgnore
        @Transient
        public void doneOneBiz() {
            this.validatorQueue.poll();
        }

        @JsonIgnore
        @Transient
        public boolean isFinished() {
            return this.validatorQueue.isEmpty();
        }
    }

    public static class EventPhaseLog {
        private Date startTime;
        private Date endTime;
        private String pluginClass;
        private boolean isValidator;
        private OpStatus status;

        public EventPhaseLog() {
        }

        public EventPhaseLog(Date startTime) {
            this.startTime = startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public String getPluginClass() {
            return this.pluginClass;
        }

        public void setPluginClass(String pluginClass) {
            this.pluginClass = pluginClass;
        }

        public OpStatus getStatus() {
            return this.status;
        }

        public void setStatus(OpStatus status) {
            this.status = status;
        }

        public boolean isValidator() {
            return this.isValidator;
        }

        public void setIsValidator(boolean validator) {
            this.isValidator = validator;
        }
    }

    public static enum OpCategory {
        DIM_CREATE_IMPORT(1, new MultiLangEnumBridge("\u7ef4\u5ea6\u521b\u5efa/\u5bfc\u5165", "OpLogs_0", "fi-bcm-common")),
        INTEL_COMBINE(2, new MultiLangEnumBridge("\u667a\u80fd\u5408\u5e76", "OpLogs_1", "fi-bcm-common")),
        REPORT(3, new MultiLangEnumBridge("\u62a5\u8868\u7f16\u5236", "OpLogs_2", "fi-bcm-common")),
        RPT_ADJUST(4, new MultiLangEnumBridge("\u8c03\u6574\u62b5\u9500\u5206\u5f55", "OpLogs_3", "fi-bcm-common"));

        private static final Map<Integer, OpCategory> myValues;
        private int code;
        private String desc;
        private MultiLangEnumBridge bridge;

        private OpCategory(int code, MultiLangEnumBridge bridge) {
            this.code = code;
            this.bridge = bridge;
        }

        public static OpCategory parse(int code) {
            return myValues.getOrDefault(code, null);
        }

        public int getCode() {
            return this.code;
        }

        public String getText() {
            return this.bridge.loadKDString();
        }

        private static OpCategory getEnumByCode(int code) {
            Optional<OpCategory> first = Arrays.stream(OpCategory.values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
            return first.orElse(null);
        }

        public static String getTextByCode(int code) {
            OpCategory enumByCode = OpCategory.getEnumByCode(code);
            if (enumByCode == null) {
                return "";
            }
            return enumByCode.getText();
        }

        static {
            myValues = new HashMap<Integer, OpCategory>(4);
            Arrays.stream(OpCategory.values()).forEach(x -> myValues.put(x.code, (OpCategory)((Object)x)));
        }
    }

    public static enum OpStatus {
        DONE(new MultiLangEnumBridge("\u5b8c\u6210", "OpLogs_4", "fi-bcm-common")),
        ABORT(new MultiLangEnumBridge("\u4e2d\u65ad", "OpLogs_5", "fi-bcm-common")),
        CANCEL(new MultiLangEnumBridge("\u53d6\u6d88", "OpLogs_6", "fi-bcm-common"));

        private MultiLangEnumBridge bridge;

        private OpStatus(MultiLangEnumBridge bridge) {
            this.bridge = bridge;
        }

        public String getText() {
            return this.bridge.loadKDString();
        }

        private static OpStatus getEnumByName(String name) {
            Optional<OpStatus> first = Arrays.stream(OpStatus.values()).filter(e -> Objects.equals(e.name(), name)).findFirst();
            return first.orElse(null);
        }

        public static String getTextByName(String name) {
            OpStatus enumByName = OpStatus.getEnumByName(name);
            if (enumByName == null) {
                return "";
            }
            return enumByName.getText();
        }
    }
}

