/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.tab;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.fi.bcm.common.tab.AbstractTabInfo;

public class TabUtil {
    public static void contructMultiTab(List<AbstractTabInfo> tabInfos, String tabKey, IFormView view) {
        TabAp tabap = new TabAp();
        tabap.setKey(tabKey);
        tabap.setName(new LocaleString(tabKey));
        tabap.setGrow(0);
        ArrayList<String> keys = new ArrayList<String>(tabInfos.size());
        for (AbstractTabInfo tab : tabInfos) {
            TabPageAp page = new TabPageAp();
            page.setKey(tab.getTabKey());
            page.setName(new LocaleString(tab.getTabName()));
            keys.add(page.getKey());
            tabap.getItems().add(page);
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e...", (String)"TabUtil_0", (String)"fi-bcm-common", (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        view.updateControlMetadata(tabKey, features);
        HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>();
        closeMap.put("closable", Boolean.TRUE);
        keys.forEach(key -> view.updateControlMetadata(key, closeMap));
    }
}

