/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.trace;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheLoader;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.util.ThreadLocals;
import kd.fi.bcm.common.mq.MQCommonPublisher;
import kd.fi.bcm.common.trace.OlapComTraceUtil;
import kd.fi.bcm.common.trace.TraceLogMsg;
import kd.fi.bcm.common.util.RequestContextUtil;

public class TraceLogCache
implements AutoCloseable {
    private static final ThreadLocal<TraceLogCache> logThreadLocals = ThreadLocals.create(TraceLogCache::new);
    private final Map<Object, Object> map = new ConcurrentHashMap<Object, Object>();
    private final RequestContext ctx = RequestContext.get();

    public static TraceLogCache current() {
        return logThreadLocals.get();
    }

    public static Object get(Object key) {
        return TraceLogCache.current().map.get(key);
    }

    public static void put(Object key, Object value) {
        TraceLogCache.current().map.put(key, value);
    }

    public static boolean exists(Object key) {
        return TraceLogCache.current().map.containsKey(key);
    }

    @Override
    public void close() throws Exception {
        this.saveBeforeDestoryCache();
    }

    public static <T> T get(Object key, CacheLoader<T> loader) {
        return TraceLogCache.get(key, loader, true);
    }

    public static <T> T get(Object key, CacheLoader<T> loader, boolean putToCache) {
        Object value = TraceLogCache.current().map.get(key);
        if (value == null && (value = loader.load()) != null && putToCache) {
            TraceLogCache.put(key, value);
        }
        return (T)value;
    }

    public static void remove(Object key) {
        TraceLogCache.current().map.remove(key);
    }

    private void saveBeforeDestoryCache() {
        TraceLogMsg log = new TraceLogMsg();
        log.setUsername(this.ctx.getUserName());
        log.setTraceid(this.ctx.getTraceId());
        boolean hasOp = this.map.containsKey(OlapComTraceUtil.getOpCacheKey(this.ctx));
        if (hasOp) {
            TraceLogMsg info = (TraceLogMsg)this.map.get(OlapComTraceUtil.getOpCacheKey(this.ctx));
            log.setOpname(info.getOpname());
            log.setOpdesc(info.getOpdesc());
            log.setOpdate(info.getOpdate());
        } else {
            OperationContext op = OperationContext.get();
            if (op != null) {
                log.setOpname(op.getOpMethod());
                log.setOpdesc(op.getFormId() + " " + op.getFormName() + " " + op.getOpKey());
            }
        }
        if (this.map.containsKey(OlapComTraceUtil.getOlapCacheKey(this.ctx))) {
            if (!hasOp) {
                log.setDetail((String)this.map.get(OlapComTraceUtil.getOlapCacheKey(this.ctx)));
            }
            if (StringUtils.isEmpty((String)log.getOpdesc())) {
                log.setOpdate(TimeServiceHelper.now());
            }
            log.setUniqueid(Long.parseLong((String)this.map.get("uniqueid")));
            RequestContextUtil.runWithCtx(this.ctx, c -> MQCommonPublisher.publishTraceLog(log));
        }
    }
}

