/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import org.apache.commons.io.IOUtils;

public class AESUtil {
    private static final String PUBLIC_KEY;
    private static final String ALG_NAME = "AES";
    private static final String AES_CIPHER_GCM_PADDING = "AES/GCM/PKCS5Padding";

    private static byte[] init(byte[] message, byte[] initKey, int modes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(ALG_NAME);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(initKey);
        keyGenerator.init(secureRandom);
        SecretKey secretKey = keyGenerator.generateKey();
        GCMParameterSpec encryptSpec = new GCMParameterSpec(128, initKey);
        Cipher cipher = Cipher.getInstance(AES_CIPHER_GCM_PADDING);
        cipher.init(modes, (Key)secretKey, encryptSpec);
        return cipher.doFinal(message);
    }

    public static String encrypt(String message) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        byte[] cipherBytes = AESUtil.init(message.getBytes(StandardCharsets.UTF_8), PUBLIC_KEY.getBytes(StandardCharsets.UTF_8), 1);
        return Base64.getEncoder().encodeToString(cipherBytes);
    }

    public static String decrypt(String cipherStr) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        byte[] cipherBytes = Base64.getDecoder().decode(cipherStr);
        byte[] dataBytes = AESUtil.init(cipherBytes, PUBLIC_KEY.getBytes(StandardCharsets.UTF_8), 2);
        return new String(dataBytes, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStringFromResources(String path) {
        try (InputStream in = AESUtil.class.getClassLoader().getResourceAsStream(path);){
            String string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u6e90\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\u3002", (String)"AESUtil_1", (String)"fi-bcm-common", (Object[])new Object[0]));
        }
    }

    static {
        String res = AESUtil.getStringFromResources("bcm/aes_key.json");
        JSONObject object = JSON.parseObject((String)res);
        PUBLIC_KEY = object.get((Object)"public_key").toString();
    }
}

