/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.function.Predicate;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.common.util.LongUtil;

public class BCMTreeUtils {
    public static void spreadAllNode(TreeNode treenode) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(true);
        if (null != treenode.getChildren()) {
            List nodes = treenode.getChildren();
            for (TreeNode t : nodes) {
                BCMTreeUtils.spreadAllNode(t);
            }
        }
    }

    public static TreeNode setEntryNode(TreeNode root, List<Map<String, String>> rootNodeList, String headId) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>(16);
        for (Map<String, String> node : rootNodeList) {
            String parentId = node.get("parentid");
            ArrayList<Map<String, String>> nodeList = (ArrayList<Map<String, String>>)nodeMap.get(parentId);
            if (nodeList == null) {
                nodeList = new ArrayList<Map<String, String>>(16);
                nodeMap.put(parentId, nodeList);
            }
            nodeList.add(node);
        }
        int maxCount = BCMTreeUtils.getMaxCount(0L);
        String searchText = ThreadCache.get((Object)"search_text") != null ? ThreadCache.get((Object)"search_text").toString() : null;
        return BCMTreeUtils.createNode(root, nodeMap, headId, maxCount, searchText);
    }

    public static TreeNode setEntryNodeWithBreak(TreeNode root, List<Map<String, String>> rootNodeList, String headId) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>();
        HashSet membIds = new HashSet();
        rootNodeList.forEach(memb -> membIds.add(memb.get("id")));
        for (Map<String, String> node : rootNodeList) {
            ArrayList<Map<String, String>> nodeList;
            String parentId = node.get("parentid");
            if (!membIds.contains(parentId)) {
                parentId = headId;
            }
            if ((nodeList = (ArrayList<Map<String, String>>)nodeMap.get(parentId)) == null) {
                nodeList = new ArrayList<Map<String, String>>();
                nodeMap.put(parentId, nodeList);
            }
            nodeList.add(node);
        }
        int maxCount = BCMTreeUtils.getMaxCount(0L);
        String searchText = ThreadCache.get((Object)"search_text") != null ? ThreadCache.get((Object)"search_text").toString() : null;
        return BCMTreeUtils.createNode(root, nodeMap, headId, maxCount, searchText);
    }

    public static TreeNode filterTree(TreeNode root, Predicate<? super TreeNode> predicate) {
        if (root == null || predicate == null) {
            throw new IllegalArgumentException();
        }
        Stack<Object> wayStack = new Stack<Object>();
        Stack<Integer> indexStack = new Stack<Integer>();
        wayStack.push(root);
        indexStack.push(0);
        while (wayStack.size() != 0) {
            TreeNode current = (TreeNode)wayStack.peek();
            if (current.getChildren() != null && current.getChildren().size() > 0) {
                if (wayStack.size() == indexStack.size()) {
                    wayStack.push(current.getChildren().get(0));
                    indexStack.push(0);
                    continue;
                }
                if (wayStack.size() + 1 == indexStack.size()) {
                    int nextPoint = (Integer)indexStack.peek() + 1;
                    if (nextPoint < current.getChildren().size()) {
                        indexStack.pop();
                        wayStack.push(current.getChildren().get(nextPoint));
                        indexStack.push(nextPoint);
                        continue;
                    }
                    indexStack.pop();
                    wayStack.pop();
                    continue;
                }
            }
            if (current.getChildren() != null && current.getChildren().size() != 0) continue;
            boolean CouldView = predicate.test((TreeNode)current);
            if (!CouldView) {
                TreeNode self = (TreeNode)wayStack.pop();
                int selfIndex = (Integer)indexStack.pop();
                if (wayStack.size() == 0) {
                    return null;
                }
                TreeNode parent = (TreeNode)wayStack.peek();
                parent.getChildren().remove(selfIndex);
                continue;
            }
            wayStack.pop();
        }
        return root;
    }

    private static TreeNode createNode(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId, int maxCount, String searchText) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null && !list.isEmpty()) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(list.size());
                root.setChildren(children);
            }
            int i = 0;
            for (Map<String, String> map : list) {
                if (maxCount != 0 && (maxCount <= 0 || ++i > maxCount) && !BCMTreeUtils.containsText(map, searchText)) continue;
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                entry.setText(map.get("name"));
                String entryHeadId = map.get("id");
                BCMTreeUtils.createNode(entry, nodeMap, entryHeadId, maxCount, searchText);
                children.add(entry);
            }
        }
        return root;
    }

    private static boolean containsText(Map<String, String> nodeMap, String searchText) {
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return false;
        }
        return nodeMap.get("number").toLowerCase(Locale.ENGLISH).contains(searchText) || nodeMap.get("name").toLowerCase(Locale.ENGLISH).contains(searchText);
    }

    private static TreeNode createNodeDm(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(list.size());
                root.setChildren(children);
            }
            int i = 0;
            int maxCount = BCMTreeUtils.getMaxCount(0L);
            for (Map<String, String> map : list) {
                if (maxCount > 0 && ++i > maxCount) {
                    return root;
                }
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                entry.setText(map.get("name"));
                String entryHeadId = map.get("id");
                if ("catalog".equals(map.get("type"))) {
                    entry.setIcon("kdfont kdfont-wenjianjia");
                }
                BCMTreeUtils.createNodeDm(entry, nodeMap, entryHeadId);
                children.add(entry);
            }
        }
        return root;
    }

    public static int getMaxCount(long modelId) {
        if (modelId == 0L) {
            modelId = LongUtil.toLong(ThreadCache.get((Object)"getModelId"));
        }
        return BCMTreeUtils.getStringParam(modelId, "dimMaxCount");
    }

    public static int getStringParam(Long modelId, String paramNum) {
        return (Integer)ThreadCache.get((Object)("BCMTreeUtils_" + modelId + paramNum), () -> {
            String config = ParamSettingServiceHelper.getString((long)modelId, (String)paramNum);
            if (StringUtils.isNotEmpty((CharSequence)config)) {
                try {
                    return Integer.parseInt(config);
                }
                catch (NumberFormatException ex) {
                    return 0;
                }
            }
            return 0;
        });
    }
}

