/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.impl.ThreadPoolImpl;

public class BatchProcessHelper {
    private static ThreadPool ASYNC_THREAD_POOL;

    public static void handleAsync(Runnable runnable) {
        ASYNC_THREAD_POOL.execute(runnable, RequestContext.get());
    }

    static {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(4, 8, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "/fi/bcm/common/batchprocesshelper/async-" + this.atomicInteger.incrementAndGet());
            }
        });
        executor.allowCoreThreadTimeOut(true);
        ASYNC_THREAD_POOL = new ThreadPoolImpl(ThreadLifeCycleManager.wrapExecutorService((ExecutorService)executor), OperationContext.get(), x -> {});
    }
}

