/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.util.InvokeUtils;

public class BlackListUtils {
    public static final Log LOG = LogFactory.getLog(BlackListUtils.class);
    private static final String CM_APP_NUM = "cm";
    private static Class<?> productSettingClass = null;

    public static List<String> getBlackFeatureByAppNum(String appNum) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("BlackFeature_" + appNum, () -> {
            try {
                Boolean isEnable = (Boolean)InvokeUtils.invokeStaticMethod("kd.fi.bcm.business.serviceHelper.ConfigServiceHelper", "getGlobalBoolParam", "isPEnableBlackList");
                if (!isEnable.booleanValue()) {
                    return new ArrayList();
                }
                if (productSettingClass != null) {
                    Method getBlackFeatureByAppId = productSettingClass.getMethod("getBlackFeatureByAppId", String.class);
                    return (List)getBlackFeatureByAppId.invoke(null, appNum);
                }
                return new ArrayList();
            }
            catch (Exception e) {
                LOG.error("BlackListServiceHelper execute error!", (Throwable)e);
                return new ArrayList();
            }
        });
    }

    public static boolean hasFeatureInCm(String featureNum) {
        return BlackListUtils.getBlackFeatureByAppNum(CM_APP_NUM).contains(featureNum);
    }

    public static boolean hasFeature(String appNum, String featureNum) {
        return BlackListUtils.getBlackFeatureByAppNum(appNum).contains(featureNum);
    }

    static {
        try {
            productSettingClass = Class.forName("kd.bos.servicehelper.productsetting.ProductSettingServiceHelper");
        }
        catch (ClassNotFoundException e) {
            LOG.error("BlackListServiceHelper init error!", (Throwable)e);
        }
    }
}

