/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;

public class BuildTreeUtil {
    public static TreeNode getTree(List<Map<String, String>> rootNodeList, String showType, boolean isAllOpen) {
        if (rootNodeList.isEmpty()) {
            return new TreeNode();
        }
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, String> map : rootNodeList) {
            String parentId = map.get("parentid");
            ArrayList<Map<String, String>> list = (ArrayList<Map<String, String>>)nodeMap.get(parentId);
            if (list == null) {
                list = new ArrayList<Map<String, String>>();
                nodeMap.put(parentId, list);
            }
            list.add(map);
        }
        Map rootNode = null;
        if (nodeMap.get("0") != null) {
            rootNode = (Map)((List)nodeMap.get("0")).get(0);
        }
        if (rootNode == null) {
            return new TreeNode();
        }
        TreeNode treeNode = BuildTreeUtil.createNode(rootNode, null, nodeMap, showType, isAllOpen);
        return treeNode;
    }

    private static TreeNode createNode(Map<String, String> map, TreeNode parentNode, Map<String, List<Map<String, String>>> nodeMap, String showType, boolean isOpen) {
        String id = map.get("id");
        String number = map.get("number");
        String parentId = map.get("parentid");
        TreeNode curNode = new TreeNode();
        curNode.setId(id);
        curNode.setData((Object)number);
        List<Map<String, String>> list = nodeMap.get(id);
        curNode.setIsOpened(isOpen);
        if (parentNode != null) {
            curNode.setParentid(parentId);
            parentNode.addChild(curNode);
        }
        if (list != null) {
            for (Map<String, String> dnm : list) {
                BuildTreeUtil.createNode(dnm, curNode, nodeMap, showType, isOpen);
            }
            curNode.setText(curNode.getText() + "(" + curNode.getChildren().size() + ")");
        }
        return curNode;
    }

    public static List<Map<String, String>> getTreeList(DynamicObjectCollection colls) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (colls.size() != 0) {
            for (int i = 0; i < colls.size(); ++i) {
                DynamicObject row = (DynamicObject)colls.get(i);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", row.getString("id"));
                map.put("number", row.getString("number"));
                Object parent = row.get("parent");
                if (parent == null) {
                    map.put("parentid", "0");
                } else if (parent instanceof DynamicObject) {
                    map.put("parentid", row.getString("parent.id"));
                } else {
                    map.put("parentid", row.getString("parent"));
                }
                map.put("isleaf", row.getString("isleaf"));
                list.add(map);
            }
        }
        return list;
    }
}

