/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.math.BigDecimal;
import java.util.function.Function;
import java.util.function.Predicate;
import kd.bos.util.StringUtils;

public class CheckValueUtil {
    public static <R> R defaultIfNull(Object v, R defaultValue, Function<Object, R> f) {
        Predicate<Object> p = t -> t == null;
        if (p.test(v)) {
            return defaultValue;
        }
        return f.apply(v);
    }

    public static boolean compareObject(Object obj1, Object obj2) {
        boolean o2null;
        if (CheckValueUtil.isLikeZero(obj1) && CheckValueUtil.isLikeZero(obj2)) {
            return true;
        }
        boolean o1null = obj1 == null || StringUtils.isEmpty((String)obj1.toString());
        boolean bl = o2null = obj2 == null || StringUtils.isEmpty((String)obj2.toString());
        if (o1null && o2null) {
            return true;
        }
        if (o1null || o2null) {
            return false;
        }
        return obj1.toString().equals(obj2.toString());
    }

    public static boolean isLikeZero(Object obj) {
        if (obj == null) {
            return true;
        }
        if (StringUtils.isEmpty((String)obj.toString())) {
            return true;
        }
        if (obj instanceof Number) {
            return new BigDecimal(obj.toString()).compareTo(BigDecimal.ZERO) == 0;
        }
        return false;
    }
}

