/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;

public class CodeRuleUtil {
    public static ICodeRuleService getCodeRuleService() {
        return (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
    }

    public static String getCodeRuleNumber(String entityNumber, String property) {
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        if (property != null) {
            dy.set(property, (Object)TimeServiceHelper.now());
        }
        return service.getNumber(entityNumber, dy, null);
    }

    public static String[] batchGetCodeRuleNumbers(String entityNumber, String property, int count) {
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        if (property != null) {
            dy.set(property, (Object)TimeServiceHelper.now());
        }
        return service.getBatchNumber(entityNumber, dy, null, count);
    }

    public static void batchRecycleCodeRuleNumbers(String entityNumber, String property, String[] numbers) {
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        if (property != null) {
            dy.set(property, (Object)TimeServiceHelper.now());
        }
        ArrayList dynamicObjects = new ArrayList(numbers.length);
        IntStream.range(0, numbers.length).forEach(ind -> dynamicObjects.add(dy));
        service.recycleBatchNumber(entityNumber, dynamicObjects.toArray(dynamicObjects.toArray(new DynamicObject[0])), null, numbers);
    }

    public static String[] getDimensionNumber(String entityNumber, DynamicObject member, int num) {
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        return service.getBatchNumber(entityNumber, member, null, num);
    }

    public static String getCodeRuleNumber(String entityNumber, String property, String propertyValue) {
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        if (property != null && propertyValue != null) {
            dy.set(property, (Object)propertyValue);
        } else {
            dy.set(property, (Object)TimeServiceHelper.now());
        }
        return service.getNumber(entityNumber, dy, null);
    }

    public static boolean recycleCodeRuleNumber(String entityNumber, String property, String propertyValue, String recycleNumber) {
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        dy.set(property, (Object)propertyValue);
        CodeRuleInfo codeRuleInfo = service.getCodeRule(entityNumber, dy, null);
        return service.recycleNumber(codeRuleInfo, dy, recycleNumber);
    }

    public static void syncCodeRuleNumbers(String entityNumber, String property, String propertyValue, String maxNumber) {
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        if (property != null && propertyValue != null) {
            dy.set(property, (Object)propertyValue);
        }
        boolean isCycled = false;
        while (!isCycled) {
            String[] batchNumbers = new String[]{};
            try {
                ArrayList dyns;
                batchNumbers = service.getBatchNumber(entityNumber, dy, null, 100);
                List<String> recycleNums = Arrays.asList(batchNumbers);
                int indexOf = recycleNums.indexOf(maxNumber);
                if (indexOf > -1 && indexOf != recycleNums.size() - 1) {
                    recycleNums = recycleNums.subList(indexOf + 1, recycleNums.size());
                    dyns = new ArrayList(recycleNums.size());
                    IntStream.range(0, recycleNums.size()).forEach(ind -> dyns.add(dy));
                    service.recycleBatchNumber(entityNumber, dyns.toArray(new DynamicObject[0]), null, recycleNums.toArray(new String[0]));
                    continue;
                }
                if (indexOf != -1 || batchNumbers[batchNumbers.length - 1].compareTo(maxNumber) <= 0) continue;
                dyns = new ArrayList(recycleNums.size());
                IntStream.range(0, recycleNums.size()).forEach(ind -> dyns.add(dy));
                service.recycleBatchNumber(entityNumber, dyns.toArray(new DynamicObject[0]), null, recycleNums.toArray(new String[0]));
                isCycled = true;
            }
            catch (Exception e) {
                isCycled = true;
            }
        }
    }
}

