/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public final class CollectionUtil {
    public static boolean isEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }

    public static Set<Integer> union(Collection<Integer> a, Collection<Integer> b) {
        LinkedHashSet<Integer> unite = new LinkedHashSet<Integer>();
        unite.addAll(a);
        unite.addAll(b);
        return unite;
    }

    public static Set<Long> unionLong(Collection<Long> a, Collection<Long> b) {
        LinkedHashSet<Long> unite = new LinkedHashSet<Long>();
        unite.addAll(a);
        unite.addAll(b);
        return unite;
    }

    public static Set<String> unionObject(Collection<String> a, Collection<String> b) {
        LinkedHashSet<String> unite = new LinkedHashSet<String>();
        unite.addAll(a);
        unite.addAll(b);
        return unite;
    }

    public static Set<Integer> intersection(Collection<Integer> a, Collection<Integer> b) {
        Set<Integer> unite = CollectionUtil.union(a, b);
        LinkedHashSet<Integer> cloneFromB = new LinkedHashSet<Integer>(b);
        unite.removeAll(a);
        cloneFromB.removeAll(unite);
        return cloneFromB;
    }

    public static Set<Long> intersectionLong(Collection<Long> a, Collection<Long> b) {
        Set<Long> unite = CollectionUtil.unionLong(a, b);
        LinkedHashSet<Long> cloneFromB = new LinkedHashSet<Long>(b);
        unite.removeAll(a);
        cloneFromB.removeAll(unite);
        return cloneFromB;
    }

    public static Set<String> intersectionObject(Collection<String> a, Collection<String> b) {
        Set<String> unite = CollectionUtil.unionObject(a, b);
        LinkedHashSet<String> cloneFromB = new LinkedHashSet<String>(b);
        unite.removeAll(a);
        cloneFromB.removeAll(unite);
        return cloneFromB;
    }

    public static Set<Integer> differenceA2B(Collection<Integer> a, Collection<Integer> b) {
        Set<Integer> intersection = CollectionUtil.intersection(a, b);
        LinkedHashSet<Integer> cloneFromA = new LinkedHashSet<Integer>(a);
        cloneFromA.removeAll(intersection);
        return cloneFromA;
    }

    public static Set<Integer> differenceB2A(Collection<Integer> a, Collection<Integer> b) {
        return CollectionUtil.differenceA2B(b, a);
    }
}

