/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.DatasourceModel;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class DataConnectCacheUtil {
    public static final String APP_BCM = "_bcm.";
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(DataConnectCacheUtil.class);

    public static void cacheDataSource(String modelNum, DatasourceModel connect) {
        if (connect != null) {
            String serial = ObjectSerialUtil.toByteSerialized(connect);
            AppCache.get((String)APP_BCM).put(modelNum, (Object)serial);
        }
    }

    public static DatasourceModel getCacheConnectAddress(String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("_epbs_conn_adr_" + modelNum, () -> {
            String serial = (String)AppCache.get((String)APP_BCM).get(modelNum, String.class);
            if (serial != null) {
                DatasourceModel connect = (DatasourceModel)ObjectSerialUtil.deSerializedBytes(serial);
                return connect;
            }
            DatasourceModel connect = DataConnectCacheUtil.getDataSource(modelNum);
            DataConnectCacheUtil.cacheDataSource(modelNum, connect);
            return connect;
        });
    }

    public static DatasourceModel getDataSource(String modelNum) {
        QFilter mFilter = new QFilter("number", "=", (Object)modelNum);
        long dataSource_id = QueryServiceHelper.queryOne((String)"bcm_model", (String)"datasource.id", (QFilter[])new QFilter[]{mFilter}).getLong("datasource.id");
        DynamicObject dataSource = QueryServiceHelper.queryOne((String)"epbs_datasource", (String)"number,dataconnect,username,password", (QFilter[])new QFilter("id", "=", (Object)dataSource_id).toArray());
        if (dataSource != null) {
            DataConnectCacheUtil.checkDataSource(dataSource.getString("number"));
            DatasourceModel connect = new DatasourceModel(dataSource.getString("dataconnect"), dataSource.getString("username"), dataSource.getString("password"));
            if (StringUtils.isEmpty((String)connect.getPassword()) || StringUtils.isEmpty((String)connect.getUsername())) {
                throw new RuntimeException("olap connection password or user name is empty,please check olap connection info is correct.");
            }
            return connect;
        }
        throw new KDBizException("not found olap connection info.");
    }

    public static void checkDataSource(String number) {
        String accountId;
        if (StringUtils.isEmpty((String)number) || ParamSettingServiceHelper.getBoolean((long)0L, (String)"isSkipDataSourceCheck")) {
            return;
        }
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObject dataSource = QueryServiceHelper.queryOne((String)"epbs_datasource", (String)"dataconnect,username,password,accountid", (QFilter[])filter.toArray());
        if (dataSource != null && StringUtils.isNotEmpty((String)(accountId = dataSource.getString("accountid"))) && !accountId.equals(RequestContext.get().getAccountId())) {
            log.error(String.format("check account fail,current account id is:%s, data source account id is:%s ", RequestContext.get().getAccountId(), accountId));
            StringBuilder errorMsg = new StringBuilder(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6e90\u7ed1\u5b9a\u7684\u6570\u636e\u8d26\u5957\u201cID\uff1a%1$s\u201d\u4e0e\u5f53\u524d\u8fd0\u884c\u7684\u6570\u636e\u8d26\u5957\u201cID\uff1a%2$s\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"DataConnectCacheUtil_1", (String)"fi-bcm-common", (Object[])new Object[0]), accountId, RequestContext.get().getAccountId())).append("\n");
            errorMsg.append(ResManager.loadKDString((String)"\u5982\u662f\u624b\u5de5\u6062\u590d\u7684\u8d26\u5957\uff0c\u53ef\u4ee5\u901a\u8fc7\u4e0b\u9762\u65b9\u6cd5\u89e3\u51b3\uff1a", (String)"DataConnectCacheUtil_2", (String)"fi-bcm-common", (Object[])new Object[0])).append("\n");
            errorMsg.append(ResManager.loadKDString((String)"1\uff09\u65b0\u589e\u5bf9\u5e94\u591a\u7ef4\u5e93\u6570\u636e\u6e90\uff1b", (String)"DataConnectCacheUtil_3", (String)"fi-bcm-common", (Object[])new Object[0])).append("\n");
            errorMsg.append(ResManager.loadKDString((String)"2\uff09\u5df2\u6709\u4f53\u7cfb\u91cd\u65b0\u7ed1\u5b9a\u65b0\u6570\u636e\u6e90\uff1b", (String)"DataConnectCacheUtil_4", (String)"fi-bcm-common", (Object[])new Object[0])).append("\n");
            errorMsg.append(ResManager.loadKDString((String)"3\uff09\u65b0\u5bfc\u5165\u4f53\u7cfb\u8bf7\u9009\u62e9\u65b0\u6570\u636e\u6e90\u5728\u64cd\u4f5c\uff1b", (String)"DataConnectCacheUtil_5", (String)"fi-bcm-common", (Object[])new Object[0])).append("\n");
            errorMsg.append(ResManager.loadKDString((String)"\u8be6\u7ec6\u6b65\u9aa4\u8bf7\u53c2\u8003\u793e\u533a\u6587\u6863\uff1a", (String)"DataConnectCacheUtil_6", (String)"fi-bcm-common", (Object[])new Object[0])).append("https://vip.kingdee.com/article/459303110238844416?productLineId=2&isKnowledge=2");
            throw new KDBizException(errorMsg.toString());
        }
    }
}

