/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.BosFieldLoader;

public class DataEntityUtils {
    public static boolean checkExistInherentAttribute(String entity, String properityNum) {
        DataEntityPropertyCollection dy = EntityMetadataCache.getDataEntityType((String)entity).getProperties();
        return dy.get((Object)properityNum) != null;
    }

    public static void removeMaimEntityInvalidataPropItem(DynamicObjectType type, DynamicProperty prop) {
        Field field = DataEntityUtils.getClassField(type.getClass(), "_properties");
        if (field == null) {
            return;
        }
        ReflectionUtils.makeAccessible((Field)field);
        try {
            DynamicPropertyCollection properties = (DynamicPropertyCollection)field.get(type);
            properties.remove((Object)prop);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    public static Field getClassField(Class<?> clazz, String fieldName) {
        Field[] fields;
        Field field = null;
        for (Field f : fields = clazz.getDeclaredFields()) {
            if (!fieldName.equals(f.getName())) continue;
            field = f;
            break;
        }
        if (field == null && clazz != Object.class) {
            field = DataEntityUtils.getClassField(clazz.getSuperclass(), fieldName);
        }
        return field;
    }

    public static void addBasedataF7ToMainEntity(Container targContainer, MainEntityType targetEntity, String f7key, String basedataEntity, IDataModel model, IFormView view) {
        BasedataProp basedataProp = new BasedataProp();
        basedataProp.setName(f7key);
        basedataProp.setBaseEntityId(basedataEntity);
        basedataProp.setDisplayProp("name");
        basedataProp.setNumberProp("number");
        LongProp idprop = new LongProp();
        idprop.setName(f7key + "_id");
        if (ApplicationTypeEnum.BGMD.getAppnum().equals(view.getFormShowParameter().getAppId())) {
            idprop.setDbIgnore(true);
        }
        basedataProp.setRefIdProp((IDataEntityProperty)idprop);
        basedataProp.setRefIdPropName(idprop.getName());
        targetEntity.addProperty((DynamicProperty)basedataProp);
        basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)basedataEntity));
        DataEntityUtils.removeMaimEntityInvalidataPropItem((DynamicObjectType)targetEntity, (DynamicProperty)basedataProp);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)basedataProp);
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)idprop);
        } else {
            targetEntity.addProperty((DynamicProperty)basedataProp);
            targetEntity.addProperty((DynamicProperty)idprop);
        }
        BasedataEdit bsEdit = new BasedataEdit();
        bsEdit.setKey(f7key);
        bsEdit.setFieldKey(f7key);
        bsEdit.setModel(model);
        bsEdit.setView(view);
        bsEdit.setDisplayProp("name");
        targContainer.getItems().add(bsEdit);
    }

    public static void addOrgBasedataF7ToMainEntity(Container targContainer, MainEntityType targetEntity, String f7key, String basedataEntity, IDataModel model, IFormView view, String orgFunc) {
        OrgProp orgProp = new OrgProp();
        orgProp.setName(f7key);
        orgProp.setBaseEntityId(basedataEntity);
        orgProp.setDisplayProp("name");
        orgProp.setNumberProp("number");
        orgProp.setOrgFunc(orgFunc);
        LongProp idprop = new LongProp();
        idprop.setName(f7key + "_id");
        orgProp.setRefIdProp((IDataEntityProperty)idprop);
        orgProp.setRefIdPropName(idprop.getName());
        targetEntity.addProperty((DynamicProperty)orgProp);
        orgProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)basedataEntity));
        DataEntityUtils.removeMaimEntityInvalidataPropItem((DynamicObjectType)targetEntity, (DynamicProperty)orgProp);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)orgProp);
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)idprop);
        } else {
            targetEntity.addProperty((DynamicProperty)orgProp);
            targetEntity.addProperty((DynamicProperty)idprop);
        }
        OrgEdit orgEdit = new OrgEdit();
        orgEdit.setKey(f7key);
        orgEdit.setFieldKey(f7key);
        orgEdit.setModel(model);
        orgEdit.setView(view);
        targContainer.getItems().add(orgEdit);
    }

    public static void addComboToMainEntity(Container targContainer, MainEntityType targetEntity, String comboKey, List<ValueMapItem> valueMapItemList, IDataModel model, IFormView view) {
        DataEntityUtils.addComboToMainEntity(targContainer, targetEntity, comboKey, valueMapItemList, null, model, view);
    }

    @Deprecated
    public static void addComboToMainEntity(Container targContainer, MainEntityType targetEntity, String comboKey, List<ValueMapItem> valueMapItemList, EntityMetadata entityMetadata, IDataModel model, IFormView view) {
        ComboProp comboProp = new ComboProp();
        comboProp.setName(comboKey);
        comboProp.setComboItems(valueMapItemList);
        targetEntity.addProperty((DynamicProperty)comboProp);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)comboProp);
        }
        FieldAp fieldAp = new FieldAp();
        fieldAp.setName(new LocaleString(comboKey));
        fieldAp.setKey(comboKey);
        ComboField comboField = new ComboField();
        comboField.setKey(comboKey);
        if (entityMetadata != null) {
            comboField.setEntityMetadata(entityMetadata);
            entityMetadata.getItems().add(comboField);
        }
        fieldAp.setField((kd.bos.metadata.entity.commonfield.Field)comboField);
        FieldEdit control = fieldAp.createRuntimeControl();
        control.setModel(model);
        control.setView(view);
        targContainer.getItems().add(control);
    }

    public static void addIntegerToMainEntity(Container targContainer, MainEntityType targetEntity, String key, IDataModel model, IFormView view) {
        DataEntityUtils.addIntegerToMainEntity(targContainer, targetEntity, key, null, model, view);
    }

    @Deprecated
    public static void addIntegerToMainEntity(Container targContainer, MainEntityType targetEntity, String key, EntityMetadata entityMetadata, IDataModel model, IFormView view) {
        IntegerProp integerProp = new IntegerProp();
        integerProp.setName(key);
        targetEntity.addProperty((DynamicProperty)integerProp);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)integerProp);
        }
        FieldAp fieldAp = new FieldAp();
        fieldAp.setName(new LocaleString(key));
        fieldAp.setKey(key);
        IntegerField integerField = new IntegerField();
        integerField.setKey(key);
        if (entityMetadata != null) {
            integerField.setEntityMetadata(entityMetadata);
            entityMetadata.getItems().add(integerField);
        }
        fieldAp.setField((kd.bos.metadata.entity.commonfield.Field)integerField);
        FieldEdit control = fieldAp.createRuntimeControl();
        control.setModel(model);
        control.setView(view);
        targContainer.getItems().add(control);
    }

    public static void addMultiBasedataF7ToMainEntity(Container targContainer, MainEntityType targetEntity, String f7key, String basedataEntity, IDataModel model, IFormView view) {
        MainEntityType originalType = EntityMetadataCache.getDataEntityType((String)basedataEntity);
        DynamicObjectType multiSelcType = new DynamicObjectType(f7key);
        multiSelcType.setAlias(originalType.getAlias());
        multiSelcType.setDbIgnore(StringUtils.isBlank((CharSequence)originalType.getAlias()));
        multiSelcType.setDBRouteKey(StringUtils.isNotBlank((CharSequence)originalType.getAlias()) ? originalType.getDBRouteKey() : "");
        multiSelcType.setExtendName(basedataEntity);
        DataEntityUtils.registerProperties(multiSelcType, basedataEntity);
        MulBasedataProp basedataProp = new MulBasedataProp(f7key, multiSelcType);
        basedataProp.setName(f7key);
        basedataProp.setBaseEntityId(basedataEntity);
        basedataProp.setDisplayProp("name");
        DataEntityUtils.makeUnmodifiable((IDataEntityType)targetEntity);
        if (targetEntity.getParent() != null) {
            DataEntityUtils.makeUnmodifiable(targetEntity.getParent());
        }
        targetEntity.addProperty((DynamicProperty)basedataProp);
        DataEntityUtils.removeMaimEntityInvalidataPropItem((DynamicObjectType)targetEntity, (DynamicProperty)basedataProp);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)basedataProp);
        } else {
            targetEntity.addProperty((DynamicProperty)basedataProp);
        }
        MulBasedataEdit bsEdit = new MulBasedataEdit();
        bsEdit.setKey(f7key);
        bsEdit.setFieldKey(f7key);
        bsEdit.setDisplayProp("name");
        bsEdit.setModel(model);
        bsEdit.setView(view);
        targContainer.getItems().add(bsEdit);
    }

    private static void makeUnmodifiable(IDataEntityType dt) {
        try {
            Method setUnmodifiable = DynamicObjectType.class.getDeclaredMethod("setUnmodifiable", Boolean.TYPE);
            ReflectionUtils.makeAccessible((Method)setUnmodifiable);
            setUnmodifiable.invoke((Object)dt, Boolean.FALSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerProperties(DynamicObjectType type, String basedataEntity) {
        String pkName = "pkid";
        LongProp pkProp = new LongProp();
        pkProp.setName(pkName);
        pkProp.setPrimaryKey(true);
        pkProp.setAlias("F" + pkName);
        type.registerSimpleProperty((DynamicSimpleProperty)pkProp);
        BasedataProp baseProp = new BasedataProp();
        baseProp.setBaseEntityId(basedataEntity);
        baseProp.setAlias("FBasedataId");
        baseProp.setName("fbasedataid");
        baseProp.setDbIgnore(true);
        baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)basedataEntity));
        baseProp.setDisplayProp("name,number");
        LongProp idprop = new LongProp();
        idprop.setName("fbasedataid_id");
        idprop.setAlias("FBasedataId");
        baseProp.setRefIdProp((IDataEntityProperty)idprop);
        baseProp.setRefIdPropName(idprop.getName());
        type.addProperty((DynamicProperty)baseProp);
        type.addProperty((DynamicProperty)idprop);
    }

    public static void addTextFieldToMainEntity(Container targContainer, MainEntityType targetEntity, String fieldKey, IDataModel model, IFormView view) {
        DataEntityUtils.addTextFieldToMainEntity(targContainer, targetEntity, null, fieldKey, model, view);
    }

    @Deprecated
    public static void addTextFieldToMainEntity(Container targContainer, MainEntityType targetEntity, EntityMetadata entityMeta, String fieldKey, IDataModel model, IFormView view) {
        TextProp fieldprop = new TextProp();
        fieldprop.setName(fieldKey);
        targetEntity.addProperty((DynamicProperty)fieldprop);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)fieldprop);
        }
        FieldAp field = new FieldAp();
        field.setName(new LocaleString(fieldKey));
        field.setKey(fieldKey);
        TextField textFiled = new TextField();
        textFiled.setKey(fieldKey);
        if (entityMeta != null) {
            textFiled.setEntityMetadata(entityMeta);
            entityMeta.getItems().add(textFiled);
        }
        field.setField((kd.bos.metadata.entity.commonfield.Field)textFiled);
        Control control = field.buildRuntimeControl();
        control.setModel(model);
        control.setView(view);
        targContainer.getItems().add(control);
    }

    public static EntryFieldAp addField2Panel(ContainerAp<Container> targPanel, Class<? extends kd.bos.metadata.entity.commonfield.Field<?>> clazz, String key, String name, boolean isLocked) {
        EntryFieldAp entryField = new EntryFieldAp();
        entryField.setKey(key);
        entryField.setName(new LocaleString(name));
        kd.bos.metadata.entity.commonfield.Field<?> ap = null;
        try {
            ap = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ap.setKey(key);
        ap.setName(entryField.getName());
        entryField.setField(ap);
        if (isLocked) {
            entryField.setLock("new,edit,view");
        }
        entryField.setTextAlign("left");
        entryField.setFieldTextAlign("left");
        entryField.setLabelDirection("h");
        entryField.setLabelWidth(new LocaleString("50px"));
        targPanel.getItems().add(entryField);
        return entryField;
    }

    public static void addF72Panel(ContainerAp<Container> targPanel, String key, String name, String entityNum, boolean isLocked) {
        EntryFieldAp f7Field = new EntryFieldAp();
        BasedataField basedata = new BasedataField();
        f7Field.setName(new LocaleString(name));
        f7Field.setKey(key);
        f7Field.setFieldTextAlign("center");
        f7Field.setTextAlign("right");
        f7Field.setAlignSelf("center");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("1px");
        margin.setTop("1px");
        margin.setBottom("10px");
        style.setMargin(margin);
        f7Field.setStyle(style);
        f7Field.setLabelDirection("h");
        if (isLocked) {
            f7Field.setLock("new,edit,view");
        }
        basedata.setKey(key);
        basedata.setBaseEntityId(entityNum);
        f7Field.setField((kd.bos.metadata.entity.commonfield.Field)basedata);
        targPanel.getItems().add(f7Field);
    }

    public static void addCheckBoxToMainEntity(Container targContainer, MainEntityType targetEntity, String key, IDataModel model, IFormView view, boolean dbIgnore) {
        DataEntityUtils.addCheckBoxToMainEntity(targContainer, targetEntity, null, key, model, view, dbIgnore);
    }

    @Deprecated
    public static void addCheckBoxToMainEntity(Container targContainer, MainEntityType targetEntity, EntityMetadata entityMeta, String key, IDataModel model, IFormView view, boolean dbIgnore) {
        BooleanProp booleanProp = new BooleanProp();
        booleanProp.setDbIgnore(dbIgnore);
        booleanProp.setName(key);
        targetEntity.addProperty((DynamicProperty)booleanProp);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)booleanProp);
        }
        FieldAp fieldAp = new FieldAp();
        fieldAp.setName(new LocaleString(key));
        fieldAp.setKey(key);
        CheckBoxField checkBoxField = new CheckBoxField();
        checkBoxField.setKey(key);
        if (entityMeta != null) {
            checkBoxField.setEntityMetadata(entityMeta);
            entityMeta.getItems().add(checkBoxField);
        }
        fieldAp.setField((kd.bos.metadata.entity.commonfield.Field)checkBoxField);
        Control control = fieldAp.buildRuntimeControl();
        control.setModel(model);
        control.setView(view);
        targContainer.getItems().add(control);
    }

    public static boolean isIncludeShareField(String dimEntityNum) {
        return !"bcm_currencymembertree".equals(dimEntityNum) && !"bcm_definedpropertyvalue".equals(dimEntityNum);
    }

    public static BasedataEdit createF7Component(String ctrlKey, IDataModel model, IFormView view, QFilter qfilter, IComponentMoreSetting<BasedataEdit> f7) {
        BasedataEdit bsEdit = new BasedataEdit();
        bsEdit.setKey(ctrlKey);
        bsEdit.setModel(model);
        bsEdit.setView(view);
        bsEdit.setFieldKey(ctrlKey);
        bsEdit.setDisplayProp("name");
        if (qfilter != null) {
            bsEdit.setQFilter(qfilter);
        }
        if (f7 != null) {
            f7.setting(bsEdit);
        }
        return bsEdit;
    }

    public static void registerField2MainEntity(Container targContainer, String fieldName, String key, String basedataEntity, IDataModel model, IFormView view, EntityMetadata entityMeta, IRegisterFieldHandle handle, Map<String, Object> specialProperties) {
        kd.bos.metadata.entity.commonfield.Field<?> field = DataEntityUtils.tryGetField(fieldName);
        field.setKey(key);
        MainEntityType targetEntity = model.getDataEntityType();
        if (entityMeta == null) {
            FormMetadata formMeta = (FormMetadata)ThreadCache.get((Object)("mainEntityTypeName:" + targetEntity.getName()), () -> (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)targetEntity.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form));
            entityMeta = (EntityMetadata)ThreadCache.get((Object)("entityId:" + formMeta.getEntityId()), () -> (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity));
        }
        field.setEntityMetadata(entityMeta);
        if (field instanceof OrgField) {
            field.setId("0");
        }
        if (targetEntity.getProperties().containsKey((Object)key)) {
            return;
        }
        try {
            ClassLoader cons = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cons.loadClass(field.getClass().getName());
            Method drivateMtd = clazz.getDeclaredMethod("createDynamicProperty", null);
            ReflectionUtils.makeAccessible((Method)drivateMtd);
            IFieldHandle prop = (IFieldHandle)drivateMtd.invoke(field, new Object[0]);
            if (prop instanceof FieldProp) {
                FieldProp fieldProp = (FieldProp)prop;
                fieldProp.setName(key);
                targetEntity.addProperty((DynamicProperty)fieldProp);
                if (targContainer instanceof EntryGrid) {
                    ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)fieldProp);
                }
            } else if (prop instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)prop;
                basedataProp.setName(key);
                basedataProp.setBaseEntityId(basedataEntity);
                basedataProp.setDisplayProp("name");
                basedataProp.setNumberProp("number");
                LongProp idprop = new LongProp();
                idprop.setName(key + "_id");
                basedataProp.setRefIdProp((IDataEntityProperty)idprop);
                basedataProp.setRefIdPropName(idprop.getName());
                targetEntity.addProperty((DynamicProperty)basedataProp);
                basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)basedataEntity));
                DataEntityUtils.removeMaimEntityInvalidataPropItem((DynamicObjectType)targetEntity, (DynamicProperty)basedataProp);
                if (targContainer instanceof EntryGrid) {
                    ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)basedataProp);
                    ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)idprop);
                } else {
                    targetEntity.addProperty((DynamicProperty)basedataProp);
                    targetEntity.addProperty((DynamicProperty)idprop);
                }
                if (prop instanceof OrgProp) {
                    ((OrgProp)prop).setOrgFunc(specialProperties.get("orgFunc").toString());
                }
            } else if (prop instanceof MulBasedataProp) {
                MainEntityType originalType = EntityMetadataCache.getDataEntityType((String)basedataEntity);
                DynamicObjectType multiSelcType = new DynamicObjectType(key);
                multiSelcType.setAlias(originalType.getAlias());
                multiSelcType.setDbIgnore(StringUtils.isBlank((CharSequence)originalType.getAlias()));
                multiSelcType.setDBRouteKey(StringUtils.isNotBlank((CharSequence)originalType.getAlias()) ? originalType.getDBRouteKey() : "");
                multiSelcType.setExtendName(basedataEntity);
                DataEntityUtils.registerProperties(multiSelcType, basedataEntity);
                MulBasedataProp basedataProp = (MulBasedataProp)prop;
                basedataProp.setItemType((IDataEntityType)multiSelcType);
                basedataProp.setName(key);
                basedataProp.setBaseEntityId(basedataEntity);
                basedataProp.setDisplayProp("name");
                targetEntity.addProperty((DynamicProperty)basedataProp);
                DataEntityUtils.removeMaimEntityInvalidataPropItem((DynamicObjectType)targetEntity, (DynamicProperty)basedataProp);
                if (targContainer instanceof EntryGrid) {
                    ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)basedataProp);
                } else {
                    targetEntity.addProperty((DynamicProperty)basedataProp);
                }
            } else if (prop instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)prop;
                comboProp.setName(key);
                List comboItems = (List)specialProperties.get("comboItems");
                comboProp.setComboItems(comboItems);
                targetEntity.addProperty((DynamicProperty)comboProp);
            }
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            entryFieldAp.setName(new LocaleString(key));
            entryFieldAp.setKey(key);
            field.setKey(key);
            entryFieldAp.setField(field);
            Control control = entryFieldAp.buildRuntimeControl();
            control.setModel(model);
            control.setView(view);
            targContainer.getItems().add(control);
            DataEntityUtils.handleF7Control(control);
            if (handle != null) {
                handle.handleField(prop, control, entryFieldAp);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void handleF7Control(Control control) {
        if (control instanceof BasedataEdit) {
            BasedataEdit bsEdit = (BasedataEdit)control;
            bsEdit.setFieldKey(control.getKey());
            bsEdit.setDisplayProp("name");
        }
    }

    public static kd.bos.metadata.entity.commonfield.Field<?> tryGetField(String fieldName) {
        return BosFieldLoader.getInstance().getField(fieldName);
    }

    public static interface IRegisterFieldHandle {
        public void handleField(IFieldHandle var1, Control var2, EntryFieldAp var3);
    }

    public static interface IComponentMoreSetting<T> {
        public void setting(T var1);
    }
}

