/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.format.TimeFormatObject;
import kd.bos.entity.list.column.BaseDataColumnDesc;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.DateColumnDesc;
import kd.bos.entity.list.column.DateTimeColumnDesc;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.fi.bcm.common.util.LongUtil;

public class DateTextFormatUtil {
    public static String getFormatDateTime(Object time) {
        if (time == null) {
            return null;
        }
        Long userId = LongUtil.toLong((Object)RequestContext.get().getUserId());
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        DynamicObject userTimezone = service.getUserTimezone(userId);
        Map fmt = service.getUserFormat(userId);
        String dateformat = fmt.get("dateFormat").toString();
        Map timeformat = (Map)fmt.get("timeFormat");
        String localStr = null;
        if (fmt.get("locale") != null) {
            localStr = fmt.get("locale").toString();
        }
        FormatObject formatObject = new FormatObject();
        DateFormatObject dateformatObj = new DateFormatObject(dateformat, userTimezone.getString("number"), localStr);
        formatObject.setDateFormat(dateformatObj);
        TimeFormatObject timeformatObj = new TimeFormatObject(timeformat.get("timeFormat").toString(), timeformat.get("am").toString(), timeformat.get("pm").toString(), userTimezone.getString("number"));
        formatObject.setTimeFormat(timeformatObj);
        return FormatFactory.get((FormatTypes)FormatTypes.Time).getFormat(formatObject).format(time);
    }

    public static void parseDateTimeToPackageData(PackageDataEvent e) {
        ColumnDesc o = (ColumnDesc)e.getSource();
        Object o1 = e.getRowData().get(o.getKey());
        if (o1 != null) {
            IFormat format = null;
            if (o instanceof BaseDataColumnDesc) {
                o = ((BaseDataColumnDesc)o).getColumnDesc();
            }
            if (o instanceof DateColumnDesc) {
                format = FormatFactory.get((FormatTypes)FormatTypes.Date);
            } else if (o instanceof DateTimeColumnDesc) {
                DateTimeProp srcProp = (DateTimeProp)((DateTimeColumnDesc)o).getSrcFieldProp();
                format = srcProp.getRegionType() == FormatTypes.Time.getValue() ? FormatFactory.get((FormatTypes)FormatTypes.Time) : FormatFactory.get((FormatTypes)FormatTypes.Date);
            }
            FormatObject fo = o.getUserFormatObject();
            if (format != null && fo != null) {
                e.setFormatValue((Object)format.getFormat(fo).format(o1));
            }
        }
    }
}

