/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class DimensionUtils {
    public static final Set<String> OLAP_NOT_ALLOW_NUMBER = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"all", "other", "none", "null"}));

    public static String checkNumber(String number) {
        if (DimensionUtils.isNotAllowNumber(number)) {
            return ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e0d\u53ef\u4e3a\u591a\u7ef4\u5e93\u4fdd\u7559\u5b57\u6bb5all\u3001other\u3001none\u3001null\u3002", (String)"DimensionUtils_1", (String)"fi-bcm-common", (Object[])new Object[0]);
        }
        Pattern pattern = Pattern.compile("^(?!_)[-a-zA-Z0-9_.]+$");
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches() || number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
            return ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimensionUtils_2", (String)"fi-bcm-common", (Object[])new Object[0]);
        }
        return null;
    }

    public static boolean isNotAllowNumber(String number) {
        return OLAP_NOT_ALLOW_NUMBER.stream().anyMatch(n -> n.equalsIgnoreCase(number));
    }

    public static List<IDNumberTreeNode> getAllSuitAuMemsOfAssoSto(long modelId) {
        Collection<IDNumberTreeNode> allAuMems = MemberReader.getAllNodeFromCache("bcm_audittrialmembertree", modelId).values();
        Set longnums = allAuMems.stream().filter(x -> "RptDS".equals(x.getNumber())).map(x -> x.getLongNumber()).collect(Collectors.toSet());
        ArrayList<IDNumberTreeNode> list = new ArrayList<IDNumberTreeNode>(10);
        allAuMems.forEach(ele -> {
            if (longnums.stream().anyMatch(x -> ele.getLongNumber().contains((CharSequence)x)) && ele.getStorageType() == StorageTypeEnum.STORAGE && DataSourceEnum.REPORTENTRY.getOIndex().equals(ele.getProperty("datasource")) && ele.getChildren().size() == 0) {
                list.add((IDNumberTreeNode)ele);
            }
        });
        return list;
    }
}

