/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.UrlUtil;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.io.FileUtils;

public class DownFileUtil {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(DownFileUtil.class);
    public static final int TIMEOUT_SECONDS = 7200;
    public static final String APP_CM = "cm";
    private static final DistributeSessionlessCache REDIS_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("");
    public static final String AUTH_DOWNLOAD_FILE_FLAG = "authDownloadFileFlag";

    public static void authorizedDownLoadFileUrl(String url, long modelId, String appId, String entityNum, String permItemId) {
        if (!StringUtils.isBlank(entityNum)) {
            String tempFileId = UrlUtil.getParam((String)url, (String)"id");
            HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
            refEntitiyMap.put("entityNum", entityNum);
            refEntitiyMap.put("appId", appId);
            refEntitiyMap.put("permissionItemId", permItemId);
            REDIS_CACHE.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
        }
    }

    public static void authorizedDownLoadFileUrl4CM(String url, long modelId, String entityNum, String permItemId) {
        DownFileUtil.authorizedDownLoadFileUrl(url, modelId, APP_CM, entityNum, permItemId);
    }

    public static File downloadFile(InputStream inputStream) {
        BufferedOutputStream output = null;
        try {
            File outFile = FileUtils.getFile((String[])new String[]{FileUtils.getTempDirectoryPath(), RequestContext.get().getRequestId() + ".xlsx"});
            FileOutputStream fos = FileUtils.openOutputStream((File)outFile);
            output = new BufferedOutputStream(fos, 1024);
            byte[] buf = new byte[1024];
            int numBytesRead = 0;
            while ((numBytesRead = inputStream.read(buf)) != -1) {
                output.write(buf, 0, numBytesRead);
            }
            output.flush();
            File file = outFile;
            return file;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (String)"ModelImportPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            if (Objects.nonNull(inputStream)) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), e);
                }
            }
        }
    }
}

