/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.spread.common.util.StringUtil;

public class DynUtils {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(true, DynUtils.class);
    public static final String FILED_ID = ".id";

    @Deprecated
    public static <T> T getProperty(DynamicObject dy, String key) {
        return DynUtils.getProperty(dy, key, null);
    }

    @Deprecated
    public static <T> T getProperty(DynamicObject dy, String key, Object defaultValue) {
        Object value = dy.get(key);
        return (T)(value == null ? defaultValue : value);
    }

    @Deprecated
    public static Long getBaseId(DynamicObject dim, String key) {
        long id = dim.getLong(key + FILED_ID);
        if (id == 0L) {
            id = dim.getLong(key);
        }
        return id;
    }

    public static Long getBaseId(String algoKey, DynamicObject dim, String key) {
        Object propertyValue = DynUtils.getProperty(algoKey, dim, key, null);
        if (propertyValue instanceof DynamicObject) {
            return (Long)DynUtils.getProperty(algoKey, (DynamicObject)propertyValue, "id", 0L);
        }
        if (propertyValue instanceof Long) {
            return (Long)propertyValue;
        }
        return (Long)DynUtils.getProperty(algoKey, dim, key.concat(FILED_ID), 0L);
    }

    public static <T> T getProperty(String algoKey, DynamicObject dy, String key, Object defaultValue) {
        Object value;
        try {
            IDataEntityProperty dataEntityProperty = DynUtils.getDataEntityProperty(algoKey, dy, key);
            value = dataEntityProperty == null ? dy.get(key) : dataEntityProperty.getValueFast((Object)dy);
        }
        catch (Throwable t) {
            log.error("error_getProperty_" + key, t);
            value = defaultValue;
        }
        return (T)(value == null ? defaultValue : value);
    }

    public static void setProperty(String algoKey, DynamicObject dy, String propertyName, Object value) {
        IDataEntityProperty dp = DynUtils.getDataEntityProperty(algoKey, dy, propertyName);
        if (dp == null) {
            dy.set(propertyName, value);
        } else {
            dp.setValueFast((Object)dy, value);
        }
    }

    public static IDataEntityProperty getDataEntityProperty(String algoKey, DynamicObject dy, String key) {
        return (IDataEntityProperty)BcmThreadCache.get(algoKey, dy.getDynamicObjectType(), key, () -> (IDataEntityProperty)dy.getDataEntityType().getProperties().get((Object)key));
    }

    public static Set<String> getDynamicTypeProperties(String entityName) {
        DynamicObjectType type = BusinessDataServiceHelper.newDynamicObject((String)entityName).getDynamicObjectType();
        return type.getProperties().stream().filter(p -> !StringUtils.isEmpty((String)p.getAlias()) && !(p instanceof DynamicCollectionProperty) && (!(p instanceof PKFieldProp) || !((PKFieldProp)p).isRefId())).map(IMetadata::getName).collect(Collectors.toSet());
    }

    public static void formatNumber(PackageDataEvent packageDataEvent, boolean noPerm) {
        Object formatValue = packageDataEvent.getFormatValue();
        if (formatValue instanceof Object[]) {
            Object[] obj = (Object[])formatValue;
            if (obj[1] == null || BigDecimal.ZERO.compareTo((BigDecimal)obj[1]) == 0) {
                obj[0] = null;
            } else if (obj[0] instanceof String) {
                if (noPerm) {
                    obj[0] = "***";
                    return;
                }
                String temp = (String)obj[0];
                if (temp.contains(".")) {
                    temp = temp.replaceFirst("[\\.]{0,1}[0]+$", "");
                    ((Object[])formatValue)[0] = temp;
                }
            }
        }
    }

    public static void formatNumber(PackageDataEvent packageDataEvent) {
        DynUtils.formatNumber(packageDataEvent, false);
    }

    public static String joinString(String delimiter, String key, Collection<DynamicObject> cols) {
        StringJoiner s = new StringJoiner(delimiter);
        if (cols != null && cols.size() > 0) {
            cols.stream().forEach(e -> {
                if (!StringUtil.isEmptyString(e.getString(key))) {
                    s.add(e.getString(key));
                }
            });
        }
        return s.toString();
    }
}

