/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class EBApproveBillQuery {
    private static final String CON_BILLAPPID = "appindexid";

    public Boolean isApproveBillContainsTaskProcessId(String appID, Long tempId, String taskProcessId) {
        QFilter qFilter = new QFilter("entryentity.tempid", "=", (Object)tempId).and("billstatus", "!=", (Object)"A");
        QFilter qAppFilter = this.getApproveBilFilter(appID);
        if (qAppFilter != null) {
            qFilter.and(qAppFilter);
        }
        QFilter[] qfilterArray = new QFilter[]{qFilter};
        String selectFiled = "id,dim_datatype,dimensionjson,dim_year,dim_period,dim_version,entryentity.tempid,entryentity.taskprocessjson,entryentity.pagedimjson ";
        DynamicObject[] approvebills = BusinessDataServiceHelper.load((String)this.getFormidByAppId(appID), (String)selectFiled, (QFilter[])qfilterArray);
        HashSet taskProcessIdSet = new HashSet();
        for (DynamicObject doc : approvebills) {
            DynamicObjectCollection dt = (DynamicObjectCollection)doc.get("entryentity");
            for (int i = 0; i < dt.size(); ++i) {
                String strTaskProcessIdjson = String.valueOf(((DynamicObject)dt.get(i)).get("taskprocessjson"));
                if (strTaskProcessIdjson.equalsIgnoreCase("null")) continue;
                Set taskSet = (Set)ObjectSerialUtil.deSerializedBytes(strTaskProcessIdjson);
                taskProcessIdSet.addAll(taskSet);
            }
            if (!taskProcessIdSet.contains(taskProcessId)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public QFilter getApproveBilFilter(String appID) {
        QFilter qFilter = null;
        if (ApplicationTypeEnum.EB.getAppnum().equalsIgnoreCase(appID) || ApplicationTypeEnum.EB.getOIndex().equalsIgnoreCase(appID)) {
            // empty if block
        }
        if (ApplicationTypeEnum.BGM.getAppnum().equalsIgnoreCase(appID) || ApplicationTypeEnum.BGM.getOIndex().equalsIgnoreCase(appID)) {
            // empty if block
        }
        return qFilter;
    }

    private String getFormidByAppId(String appID) {
        String strReturn = "";
        if (ApplicationTypeEnum.EB.getAppnum().equalsIgnoreCase(appID)) {
            strReturn = "bcm_eb_approvebill";
        }
        if (ApplicationTypeEnum.BGM.getAppnum().equalsIgnoreCase(appID)) {
            strReturn = "eb_approvebill";
        }
        return strReturn;
    }
}

