/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;

public class InvestUtils {
    public static final BigDecimal HUNDRED = new BigDecimal("100");

    public static void updateInvChangeStatus(long modelId, DynamicObject[] entryEntity) {
        if (entryEntity.length > 0) {
            QFilter filters = QFilter.of((String)"modelid = ?", (Object[])new Object[]{modelId});
            Date early = null;
            for (DynamicObject entry : entryEntity) {
                Date investDate = entry.getDate("investdate");
                if (early == null) {
                    early = investDate;
                    continue;
                }
                if (!early.after(investDate)) continue;
                early = investDate;
            }
            QFilter orFilter = QFilter.of((String)"starttime >= ?", (Object[])new Object[]{early});
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_invchangestatus", (String)"id, status", (QFilter[])filters.and(orFilter).toArray());
            if (load.length > 0) {
                Stream.of(load).forEach(v -> v.set("status", (Object)Boolean.FALSE));
                SaveServiceHelper.save((DynamicObject[])load);
            }
        }
    }

    public static void deleteInvChangeStatus(long model, long scenario, long year, long period) {
        QFBuilder qfBuilder = new QFBuilder("modelid", "=", model);
        qfBuilder.add("scenarioid", "=", scenario);
        qfBuilder.add("fyid", "=", year);
        qfBuilder.add("periodid", "=", period);
        if (QueryServiceHelper.exists((String)"bcm_invchangestatus", (QFilter[])qfBuilder.toArray())) {
            DeleteServiceHelper.delete((String)"bcm_invchangestatus", (QFilter[])qfBuilder.toArray());
        }
        ORM orm = ORM.create();
        DynamicObject dyna = orm.newDynamicObject("bcm_invchangestatus");
        Date[] from2End = PeriodUtils.calcStartAndEndDate(model, year, period);
        dyna.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dyna.set("modelid", (Object)model);
        dyna.set("scenarioid", (Object)scenario);
        dyna.set("fyid", (Object)year);
        dyna.set("periodid", (Object)period);
        dyna.set("starttime", (Object)from2End[0]);
        dyna.set("endtime", (Object)from2End[1]);
        dyna.set("status", (Object)"1");
        SaveServiceHelper.save((IDataEntityType)dyna.getDataEntityType(), (Object[])new Object[]{dyna});
    }

    public static boolean checkAmountOutOfRange(BigDecimal investAmount) {
        int scale = investAmount.scale();
        int precision = investAmount.precision() - investAmount.scale();
        return scale <= 6 && precision <= 13;
    }

    public static double convertToDouble(Object investAmount) {
        return investAmount == null ? BigDecimal.ZERO.doubleValue() : new BigDecimal(investAmount.toString()).doubleValue();
    }

    public static Integer convertToInteger(Object investAmount, Integer defaultVal) {
        Integer bic;
        try {
            bic = investAmount == null ? null : Integer.valueOf(Integer.parseInt(investAmount.toString()));
        }
        catch (Exception e) {
            bic = null;
        }
        return bic == null ? defaultVal : bic;
    }

    public static boolean isNullDouble(Double investAmount) {
        return investAmount.compareTo(0.0) == 0;
    }

    public static BigDecimal convertToBigDecimal(Object investAmount) {
        if (investAmount instanceof BigDecimal) {
            return (BigDecimal)investAmount;
        }
        BigDecimal bic = BigDecimal.ZERO;
        try {
            bic = investAmount == null ? BigDecimal.ZERO : new BigDecimal(new BigDecimal(investAmount.toString()).toPlainString());
            bic = bic == null ? null : bic.stripTrailingZeros();
        }
        catch (Exception e) {
            try {
                bic = null;
                bic = bic == null ? null : bic.stripTrailingZeros();
            }
            catch (Throwable throwable) {
                bic = bic == null ? null : bic.stripTrailingZeros();
                throw throwable;
            }
        }
        return bic;
    }

    public static int getIntegerDigits(BigDecimal number) {
        String numberStr = number.abs().stripTrailingZeros().toPlainString();
        int index = numberStr.indexOf(46);
        if (index == -1) {
            return numberStr.length();
        }
        return index;
    }

    public static boolean isPercentNum(BigDecimal num) {
        if (num != null) {
            return num.compareTo(new BigDecimal(100)) <= 0 && num.compareTo(new BigDecimal(0)) >= 0;
        }
        return false;
    }
}

