/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.fi.bcm.fel.common.StringUtils;

public class LongUtil {
    private LongUtil() {
    }

    public static Long toLong(Object obj) {
        if (obj == null) {
            return 0L;
        }
        return LongUtil.toLong(obj.toString());
    }

    private static Long toLong(String str) {
        if (StringUtils.isBlank(str)) {
            return 0L;
        }
        return Long.valueOf(str);
    }

    public static List<Long> toLongList(Collection<String> list) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (list != null && list.size() > 0) {
            list.forEach(id -> result.add(LongUtil.toLong(id)));
        }
        return result;
    }

    public static boolean isvalidLong(Object obj) {
        long temp;
        if (Objects.isNull(obj)) {
            return false;
        }
        if (obj instanceof Long) {
            temp = (Long)obj;
        } else {
            try {
                temp = Long.parseLong(obj.toString());
            }
            catch (Throwable t) {
                return false;
            }
        }
        return temp != 0L;
    }
}

