/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.PropertiesUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.apache.commons.lang.StringUtils;

public class MethodParamsValidator {
    private static final Map<String, List<String[]>> constants = new HashMap<String, List<String[]>>();
    private static boolean isInit = false;
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(true, MethodParamsValidator.class);
    private static final Map<String, String> typeAddPackage = new HashMap<String, String>();

    public static int checkAndReturnParamType(String key, Object[] args) {
        List<String[]> list;
        int index = -1;
        if (!isInit) {
            Properties properties = new Properties();
            try {
                InputStream inputStream = PropertiesUtil.class.getResourceAsStream("/params/params_config.properties");
                Object object = null;
                try {
                    properties.load(inputStream);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String name = (String)entry.getKey();
                        String val = (String)entry.getValue();
                        LinkedList<String[]> types = new LinkedList<String[]>();
                        for (String type : val.split(";")) {
                            if (!StringUtils.isNotEmpty((String)type)) continue;
                            String[] params = type.split(",");
                            String[] newParams = Arrays.copyOf(params, params.length);
                            types.add(newParams);
                        }
                        constants.put(key, types);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (inputStream != null) {
                        if (object != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
            isInit = true;
        }
        if ((list = constants.get(key)) == null) {
            throw new KDBizException("params not config");
        }
        int cur = 0;
        block15: for (String[] strings : list) {
            if (strings.length == args.length) {
                for (int i = 0; i < strings.length; ++i) {
                    try {
                        String allPath = typeAddPackage.get(strings[i]);
                        if (allPath == null) {
                            throw new KDBizException("param type not config");
                        }
                        Class<?> src = Class.forName(allPath);
                        if (args[i] == null || args[i].getClass() != src) break;
                        if (i != strings.length - 1) continue;
                        break block15;
                    }
                    catch (ClassNotFoundException e) {
                        LOG.error(e.getMessage());
                    }
                }
            }
            ++cur;
        }
        if ((index = cur) < 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u53c2\u6570\u5b9a\u4e49\u9519\u8bef", (String)"MethodParamsValidator_0", (String)"fi-bcm-common", (Object[])new Object[0]), key));
        }
        return index;
    }

    static {
        typeAddPackage.put("String", "java.lang.String");
        typeAddPackage.put("Boolean", "java.lang.Boolean");
        typeAddPackage.put("XDMScopeInfo", "kd.fi.bcm.computing.XDMScopeInfo");
        typeAddPackage.put("Integer", "java.lang.Integer");
        typeAddPackage.put("Long", "java.lang.Long");
        typeAddPackage.put("BigDecimal", "java.math.BigDecimal");
    }
}

