/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.lang.reflect.Method;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;

public class OlapCommandUtil {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(true, OlapCommandUtil.class);
    private static final Method checkMeasure;
    private static final Class<?> olapServiceHelper;
    public static final String UNCHECKSOURCE = "unchecksource";

    public static void addSourceMeasure(String modelNum, CommandInfo cmd, OlapSourceEnum type) {
        OlapCommandUtil.addSourceMeasure(modelNum, cmd, type.getType());
    }

    public static void addSourceMeasure(String modelNum, CommandInfo info, Integer type) {
        if (OlapCommandUtil.checkMeasure(modelNum, FacTabFieldDefEnum.FIELD_SOURCE.getField())) {
            try {
                List measures;
                if (info instanceof SaveCommandInfo && (measures = ((SaveCommandInfo)info).getMeasures()).size() == 1 && !FacTabFieldDefEnum.FIELD_MONEY.getField().equals(measures.get(0))) {
                    return;
                }
                if (info instanceof ComputingCommandInfo && !FacTabFieldDefEnum.FIELD_MONEY.getField().equals(((ComputingCommandInfo)info).getMainMeaName())) {
                    return;
                }
                Method method = info.getClass().getMethod("addFixedMeasure", String.class, Object.class);
                method.invoke((Object)info, FacTabFieldDefEnum.FIELD_SOURCE.getField(), type);
            }
            catch (Throwable e) {
                logger.error("addFixedMeasure fail." + ThrowableHelper.toString(e));
            }
        }
    }

    public static void setReadonlyExpression(MetadataCommandInfo cmd, boolean readonly) {
        try {
            Method method = cmd.getClass().getMethod("setReadonlyExpression", String.class);
            method.invoke((Object)cmd, readonly ? "[__Measures__.FLock] == 1" : "");
        }
        catch (Throwable e) {
            logger.error("setReadonlyExpression fail." + ThrowableHelper.toString(e));
        }
    }

    public static boolean checkMeasure(String modelNum, String measure) {
        try {
            return (Boolean)checkMeasure.invoke(olapServiceHelper, modelNum, measure);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void checkIsSetSource(String modelNum, CommandInfo info) {
        if (ThreadCache.get((Object)UNCHECKSOURCE) != null) {
            return;
        }
        if (OlapCommandUtil.checkMeasure(modelNum, FacTabFieldDefEnum.FIELD_SOURCE.getField())) {
            try {
                Method getFixedMeasures;
                if ("true".equals(System.getProperty("bcm.dev")) && ((List)(getFixedMeasures = info.getClass().getMethod("getFixedMeasures", new Class[0])).invoke((Object)info, new Object[0])).size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u6ca1\u6709\u8bbe\u7f6e\u591a\u7ef4\u6eaf\u6e90\u3002", (String)"OlapCommandUtil_1", (String)"fi-bcm-common", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        try {
            olapServiceHelper = Class.forName("kd.fi.bcm.business.serviceHelper.OlapServiceHelper");
            checkMeasure = olapServiceHelper.getMethod("checkMeasure", String.class, String.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

