/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FyEnum;
import kd.fi.bcm.common.enums.ScenarioMemberEnum;
import kd.fi.bcm.common.util.DateUtils;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.tuple.Triple;

public class PeriodUtils {
    private static final String[] array = new String[]{"M_", "Q_", "YD_", "YW_", "HF_"};
    public static final String P_M_01_PREFIX = "M_M";
    public static final String P_YD_M_PREFIX = "YD_M";
    public static final String P_YD_D_PREFIX = "YD_D";
    public static final String P_M_Q1_PREFIX = "M_Q";
    public static final String P_M_HF1_PREFIX = "M_HF";
    public static final String P_Q_HF1_PREFIX = "Q_HF";
    public static final String P_Q_Q1_PREFIX = "Q_Q";
    public static final String P_HF_HF1_PREFIX = "HF_HF";
    public static final String NOT_STANDARD_PERIOD = "not_standard_period";
    public static final String FY_PREFIX = "FY";
    public static final Set<String> Standard_Period = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"M_M", "M_Q", "M_HF", "Q_HF", "Q_Q", "HF_HF", "YD_M", "YD_D"}));
    public static final List<String> STANDARD_MONTH_PERIOD = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"M_M01", "M_M02", "M_M03", "M_M04", "M_M05", "M_M06", "M_M07", "M_M08", "M_M09", "M_M10", "M_M11", "M_M12"}));
    public static final Set<String> STANDARD_MONTH_PERIOD_SET = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"M_M01", "M_M02", "M_M03", "M_M04", "M_M05", "M_M06", "M_M07", "M_M08", "M_M09", "M_M10", "M_M11", "M_M12"}));
    public static final List<String> SPECIAL_MONTH_PERIOD = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"M_M13", "M_M14", "M_M15", "M_M16"}));
    private static final int[] dayofMonth = new int[SysMembConstant.dayofMonth.size()];
    public static final DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final String IS_EXIST_JAN_LAST_PERIOD = "isExistJanLastPeirod";
    public static final String SPECIFIC_FY = "specificFy";
    public static final String SPECIFIC_PERIOD = "specificPeriod";
    public static final String IS_REMOVE_YEAR = "isRemoveYear";
    public static final int yearIndex = 0;
    public static final int periodIndex = 1;

    public static String formatDate(Date date) {
        return PeriodUtils.formatDate(date, df);
    }

    public static String formatDate(Date date, DateTimeFormatter df) {
        LocalDateTime datetime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return datetime.format(df);
    }

    public static boolean isStandardPeriod(String period) {
        if (StringUtils.isEmpty((String)period)) {
            return false;
        }
        return Standard_Period.stream().anyMatch(p -> period.startsWith((String)p));
    }

    public static String getPeriodType(String period) {
        for (String pf : Standard_Period) {
            if (!period.startsWith(pf)) continue;
            return pf;
        }
        return NOT_STANDARD_PERIOD;
    }

    public static Object trans2IntPeriod(String period) {
        if (!PeriodUtils.isStandardPeriod(period)) {
            throw new KDBizException(String.format("%s is not standard period prefix,can't trans to int value!", period));
        }
        int periodInt = 0;
        for (String pf : Standard_Period) {
            if (!period.startsWith(pf)) continue;
            String periodStr = period.substring(pf.length());
            if (NumberUtils.isNumber((String)periodStr)) {
                periodInt = Integer.parseInt(period.substring(pf.length()));
                continue;
            }
            return period;
        }
        return periodInt;
    }

    public static int trans2IntPeriod(String modelNum, String period) {
        if (!PeriodUtils.isStandardPeriod(period)) {
            throw new KDBizException(String.format("%s is not standard period prefix,can't trans to int value!", period));
        }
        int periodInt = 0;
        for (String pf : Standard_Period) {
            if (!period.startsWith(pf)) continue;
            Optional<IDNumberTreeNode> node = PeriodUtils.getNodeByNumber(modelNum, period);
            if (node.isPresent()) {
                String relatedNumber = (String)node.get().getProperty("relatednumber");
                period = StringUtils.isNotEmpty((String)relatedNumber) ? relatedNumber : period;
            }
            periodInt = Integer.parseInt(period.substring(pf.length()));
        }
        return periodInt;
    }

    public static Optional<String> trans2SpecificPeriod(String modelNum, String currentRuntimePeriod, String periodNum, boolean isIncludeAdjPeriod) {
        if ("LastPeriod".equals(periodNum)) {
            return PeriodUtils.getLastPeriod(modelNum, currentRuntimePeriod, isIncludeAdjPeriod);
        }
        if ("CurrentPeriod".equals(periodNum)) {
            return Optional.of(currentRuntimePeriod);
        }
        return Optional.of(periodNum);
    }

    public static Optional<String> trans2SpecificPeriod(String modelNum, String yearNum, String currentRuntimePeriod, String periodNum, boolean isIncludeAdjPeriod) {
        if ("LastPeriod".equals(periodNum)) {
            return PeriodUtils.getLastPeriod(modelNum, yearNum, currentRuntimePeriod, isIncludeAdjPeriod);
        }
        if ("CurrentPeriod".equals(periodNum)) {
            return Optional.of(currentRuntimePeriod);
        }
        return Optional.of(periodNum);
    }

    public static Pair<String, String> trans2SpecificPeriodForReport(String modelNum, String currentRuntimeScene, String currentRuntimePeriod, String currentRuntimeYear, String periodNum) {
        if (org.apache.commons.lang3.StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{modelNum, currentRuntimeScene, currentRuntimeYear, currentRuntimePeriod, periodNum})) {
            return Pair.onePair(currentRuntimeYear, periodNum);
        }
        if (Arrays.asList("LastYear", "CurrentYear", "AllYear", "Year").contains(currentRuntimeYear)) {
            return Pair.onePair(currentRuntimeYear, periodNum);
        }
        if ("LastPeriod".equals(periodNum)) {
            return (Pair)ThreadCache.get((Object)(modelNum + "_" + currentRuntimeScene + "_" + currentRuntimeYear + "_" + currentRuntimePeriod), () -> {
                String[] result = PeriodUtils.isFirstPeriod(modelNum, currentRuntimePeriod) ? PeriodUtils.getLastPeriodByCarry(modelNum, currentRuntimeScene, currentRuntimePeriod, currentRuntimeYear) : PeriodUtils.getLastPeriodIncludeYear(modelNum, currentRuntimeYear, currentRuntimePeriod, true);
                return Pair.onePair(result[0], result[1]);
            });
        }
        if ("CurrentPeriod".equals(periodNum)) {
            return Pair.onePair(currentRuntimeYear, currentRuntimePeriod);
        }
        return Pair.onePair(currentRuntimeYear, periodNum);
    }

    private static String[] getLastPeriodByCarry(String modelNum, String currentRuntimeScene, String currentRuntimePeriod, String currentRuntimeYear) {
        Long modelId = MemberReader.findModelIdByNum(modelNum);
        Long sceneId = MemberReader.findScenaMemberByNum(modelNum, currentRuntimeScene).getId();
        Long yearId = MemberReader.findFyMemberByNum(modelNum, currentRuntimeYear).getId();
        Long periodId = MemberReader.findPeriodMemberByNum(modelNum, currentRuntimePeriod).getId();
        QFilter modelQFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject carryMap = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_carrymap", (QFilter[])new QFilter[]{modelQFilter, new QFilter("scenario", "=", (Object)sceneId), new QFilter("year", "=", (Object)yearId)});
        if (carryMap != null) {
            DynamicObjectCollection carrymapentry = carryMap.getDynamicObjectCollection("entryentity");
            DynamicObject setting = carrymapentry.stream().filter(d -> d.getLong("curyear.id") == yearId.longValue() && d.getLong("curperiod.id") == periodId.longValue()).findAny().orElse(null);
            if (setting != null) {
                String lastPeriod = setting.getString("lastperiod.number");
                Optional<String> year = PeriodUtils.getLastYear(modelNum, currentRuntimeYear);
                return new String[]{year.orElse(null), lastPeriod};
            }
            return new String[]{null, currentRuntimePeriod};
        }
        return PeriodUtils.getLastPeriodIncludeYear(modelNum, currentRuntimeYear, currentRuntimePeriod, true);
    }

    public static Optional<String> trans2SpecificFy(String modelNum, String currentRuntimeFy, String fyNum) {
        if ("LastYear".equals(fyNum)) {
            return PeriodUtils.getLastYear(modelNum, currentRuntimeFy);
        }
        if ("CurrentYear".equals(fyNum)) {
            return Optional.of(currentRuntimeFy);
        }
        return Optional.of(fyNum);
    }

    public static Optional<String> getLastPeriod(String modelNum, String periodNum, boolean isIncludeAdjPeriod) {
        return GlobalCacheServiceHelper.getOrLoadNode("getLastPeriod:" + modelNum + periodNum + isIncludeAdjPeriod, () -> {
            String lastPeriod = null;
            for (int i = 0; i < SysMembConstant.dayofMonth.size(); ++i) {
                PeriodUtils.dayofMonth[i] = SysMembConstant.dayofMonth.get(i);
            }
            try {
                boolean isYD_Day = periodNum.startsWith("YD_");
                String[] splitArr = PeriodUtils.splitPeriod(periodNum);
                if (PeriodUtils.isFirstPeriod(modelNum, periodNum)) {
                    if (!isYD_Day && isIncludeAdjPeriod) {
                        QFBuilder qf = new QFBuilder();
                        qf.add("number", "like", splitArr[0] + "%");
                        qf.add("model.number", "=", modelNum);
                        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"number", (QFilter[])qf.toArray(), (String)"number desc", (int)1);
                        if (coll.size() > 0) {
                            lastPeriod = ((DynamicObject)coll.get(0)).getString("number");
                        }
                    } else {
                        lastPeriod = PeriodUtils.transLastPeriod(splitArr[0]);
                    }
                } else {
                    if (isYD_Day) {
                        if (P_YD_M_PREFIX.equals(splitArr[0])) {
                            lastPeriod = String.format("%02d", Integer.parseInt(splitArr[1]) - 1);
                        } else if (P_YD_D_PREFIX.equals(splitArr[0])) {
                            int mouth = Integer.parseInt(splitArr[1].substring(0, 2));
                            int day = Integer.parseInt(splitArr[1].substring(2));
                            if (--day == 0) {
                                day = dayofMonth[--mouth];
                            }
                            lastPeriod = String.format("%02d%02d", mouth, day);
                        }
                        return Optional.ofNullable(splitArr[0] + lastPeriod);
                    }
                    int intPeriod = Integer.parseInt(splitArr[1]);
                    intPeriod = intPeriod > 12 && P_M_01_PREFIX.equals(splitArr[0]) ? 11 : (intPeriod > 4 && P_Q_Q1_PREFIX.equals(splitArr[0]) ? 3 : (intPeriod > 2 && P_HF_HF1_PREFIX.equals(splitArr[0]) ? 1 : --intPeriod));
                    lastPeriod = PeriodUtils.combiePeriod(intPeriod, splitArr[0]);
                }
                return Optional.ofNullable(lastPeriod);
            }
            catch (NumberFormatException e) {
                lastPeriod = null;
                return Optional.ofNullable(lastPeriod);
            }
        });
    }

    public static String getLastPeriodElseThrowException(String modelNum, String periodNum, boolean isIncludeAdjPeriod) {
        String lastPeriod = PeriodUtils.getLastPeriod(modelNum, periodNum, isIncludeAdjPeriod).orElse(null);
        if (lastPeriod != null) {
            return lastPeriod;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u662f\u8be5\u4f53\u7cfb\u6700\u65e9\u7684\u671f\u95f4\u3002", (String)"PeriodUtils_0", (String)"fi-bcm-common", (Object[])new Object[0]));
    }

    public static Optional<String> getLastYear(String modelNum, String fyNum) {
        int year = Integer.parseInt(fyNum.substring(FY_PREFIX.length()));
        String lastFY = FY_PREFIX + --year;
        IDNumberTreeNode lastYear = MemberReader.findFyMemberByNum(modelNum, lastFY);
        if (IDNumberTreeNode.NotFoundTreeNode.equals(lastYear)) {
            lastFY = null;
        }
        return Optional.ofNullable(lastFY);
    }

    public static String lastYear(String cube, String fyNumber) {
        try {
            Optional<String> lastYear = PeriodUtils.getLastYear(cube, fyNumber);
            if (lastYear.isPresent()) {
                return lastYear.get();
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    public static Optional<String> getNextYear(String modelNum, String fyNum) {
        int year = Integer.parseInt(fyNum.substring(FY_PREFIX.length()));
        String lastFY = FY_PREFIX + ++year;
        IDNumberTreeNode lastYear = MemberReader.findFyMemberByNum(modelNum, lastFY);
        if (IDNumberTreeNode.NotFoundTreeNode.equals(lastYear)) {
            lastFY = null;
        }
        return Optional.ofNullable(lastFY);
    }

    public static String getLastYearElseThrowException(String modelNum, String fyNum) {
        String lastFY = PeriodUtils.getLastYear(modelNum, fyNum).orElse(null);
        if (lastFY != null) {
            return lastFY;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5e74\u5df2\u7ecf\u662f\u8be5\u4f53\u7cfb\u6700\u65e9\u7684\u8d22\u5e74\u3002", (String)"PeriodUtils_1", (String)"fi-bcm-common", (Object[])new Object[0]));
    }

    public static String[] getLastPeriodIncludeYear(String modelNum, String currFYNum, String currPeriodNum, boolean isIncludeAdjPeriod) {
        Optional<String> lastPeriod = PeriodUtils.getLastPeriod(modelNum, currFYNum, currPeriodNum, isIncludeAdjPeriod);
        String periodNum = lastPeriod.orElse(null);
        if (PeriodUtils.isFirstPeriod(modelNum, currPeriodNum)) {
            Optional<String> year = PeriodUtils.getLastYear(modelNum, currFYNum);
            return new String[]{year.orElse(null), periodNum};
        }
        return new String[]{currFYNum, periodNum};
    }

    private static String transLastPeriod(String periodPrefix) {
        switch (periodPrefix) {
            case "YD_M": 
            case "M_M": {
                return periodPrefix + "12";
            }
            case "YD_D": {
                return periodPrefix + "1231";
            }
            case "M_Q": {
                return periodPrefix + "4";
            }
            case "M_HF": {
                return periodPrefix + "2";
            }
            case "Q_HF": {
                return periodPrefix + "2";
            }
            case "Q_Q": {
                return periodPrefix + "4";
            }
            case "HF_HF": {
                return periodPrefix + "2";
            }
        }
        throw new KDBizException("not support Period" + periodPrefix);
    }

    public static boolean isFirstPeriod(String periodNum) {
        return "M_M01".equals(periodNum) || "M_Q1".equals(periodNum) || "M_HF1".equals(periodNum) || "Q_HF1".equals(periodNum) || "Q_Q1".equals(periodNum) || "HF_HF1".equals(periodNum) || "YD_M01".equals(periodNum) || "YD_D0101".equals(periodNum);
    }

    public static boolean isFirstPeriod(String modelNum, String periodNum) {
        Optional<IDNumberTreeNode> period;
        if (StringUtils.isNotEmpty((String)modelNum) && !PeriodUtils.isStandardMonthPeriod(periodNum) && periodNum.startsWith(P_M_01_PREFIX) && (period = PeriodUtils.getNodeByNumber(modelNum, periodNum)).isPresent()) {
            return "M_M01".equals(period.get().getProperty("relatednumber"));
        }
        return PeriodUtils.isFirstPeriod(periodNum);
    }

    public static String[] splitPeriod(String periodNum) {
        char[] chars = periodNum.toCharArray();
        int from = 0;
        for (int i = 0; i < chars.length; ++i) {
            from = i;
            if (Character.isDigit(chars[i])) break;
        }
        return new String[]{periodNum.substring(0, from), periodNum.substring(from)};
    }

    public static int splitPeriod2Int(String periodNum) {
        char[] chars = periodNum.toCharArray();
        int from = 0;
        for (int i = 0; i < chars.length; ++i) {
            from = i;
            if (Character.isDigit(chars[i])) break;
        }
        return Integer.parseInt(new String(Arrays.copyOfRange(chars, from, chars.length)));
    }

    public static String splitPeriod2AllInt(String periodNum) {
        char[] chars = periodNum.toCharArray();
        int from = 0;
        for (int i = 0; i < chars.length; ++i) {
            from = i;
            if (Character.isDigit(chars[i])) break;
        }
        return new String(Arrays.copyOfRange(chars, from, chars.length));
    }

    public static String combiePeriod(int intPeriod, String periodPrefix) {
        switch (periodPrefix) {
            case "M_M": {
                return String.format("%s%s", periodPrefix, intPeriod < 10 ? "0" + intPeriod : "" + intPeriod);
            }
        }
        return String.format("%s%d", periodPrefix, intPeriod);
    }

    public static Date[] calcStartAndEndDate(long modelId, long fyId, long periodId) {
        DynamicObject fy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_fymembertree", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fyId)});
        String yearNum = fy.getString("number");
        return PeriodUtils.calcStartAndEndDate(modelId, yearNum, periodId);
    }

    public static Date[] calcStartAndEndDate(long modelId, String yearNum, long periodId) {
        Date endDate;
        Date startDate;
        IDNumberTreeNode period = MemberReader.findPeriodMemberById(modelId, (Long)periodId);
        try {
            int year = Integer.parseInt(yearNum.substring(2));
            int startMonth = Integer.parseInt(period.getProperty("effmonth").toString());
            int endMonth = Integer.parseInt(period.getProperty("expmonth").toString());
            int startDay = Integer.parseInt(period.getProperty("effday").toString());
            int endDay = Integer.parseInt(period.getProperty("expday").toString());
            startDate = PeriodUtils.calcDate(year, startMonth, startDay);
            endDate = PeriodUtils.calcDate(year, endMonth, endDay);
        }
        catch (Exception e) {
            startDate = null;
            endDate = null;
        }
        return new Date[]{startDate, endDate};
    }

    public static Date[] calcStartAndEndDate(long modelId, String yearNum, String periodNum) {
        Date endDate;
        Date startDate;
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)periodNum)});
        try {
            int year = Integer.parseInt(yearNum.substring(2));
            int startMonth = period.getInt("effmonth");
            int endMonth = period.getInt("expmonth");
            int startDay = period.getInt("effday");
            int endDay = period.getInt("expday");
            startDate = PeriodUtils.calcDate(year, startMonth, startDay);
            endDate = PeriodUtils.calcDate(year, endMonth, endDay);
        }
        catch (Exception e) {
            startDate = null;
            endDate = null;
        }
        return new Date[]{startDate, endDate};
    }

    private static Date calcDate(int year, int month, int day) {
        if (month == 2 && day == 29 && !PeriodUtils.isLeapYear(year)) {
            day = 28;
        }
        LocalDate localDate = LocalDate.of(year, month, day);
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        Instant instant1 = zonedDateTime.toInstant();
        Date from = Date.from(instant1);
        return from;
    }

    public static Date[] calcStartAndEndDateTime(long modelId, String yearNum, long periodId) {
        Date endDate;
        Date startDate;
        DynamicObject period = PeriodUtils.getPeriodFilter(periodId);
        String beginyearofmonth = PeriodUtils.getModelFilter(modelId).getString("beginyearofmonth");
        int year = Integer.parseInt(yearNum.substring(2));
        if (FyEnum.PRE.index.equals(beginyearofmonth)) {
            --year;
        }
        try {
            int startMonth = period.getInt("effmonth");
            int endMonth = period.getInt("expmonth");
            int startDay = period.getInt("effday");
            int endDay = period.getInt("expday");
            startDate = PeriodUtils.calcDateTime(year, startMonth, startDay, 0, 0, 0, 0);
            endDate = PeriodUtils.calcDateTime(year, endMonth, endDay, 23, 59, 59, 999);
        }
        catch (Exception e) {
            startDate = null;
            endDate = null;
        }
        return new Date[]{startDate, endDate};
    }

    private static Date calcDateTime(int year, int month, int day, int hour, int minute, int second, int nano) {
        if (month == 2 && day == 29 && !PeriodUtils.isLeapYear(year)) {
            day = 28;
        }
        LocalDateTime localDateTime = LocalDateTime.of(year, month, day, hour, minute, second, nano);
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        Instant instant1 = zonedDateTime.toInstant();
        Date from = Date.from(instant1);
        return from;
    }

    private static DynamicObject getModelFilter(Long modelId) {
        return (DynamicObject)ThreadCache.get((Object)(modelId + "PeriodUtils"), () -> BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"bcm_model", (String)"id, beginyearofmonth"));
    }

    private static DynamicObject getPeriodFilter(Long periodId) {
        return (DynamicObject)ThreadCache.get((Object)(periodId + "PeriodUtils"), () -> BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bcm_periodmembertree", (String)"id, effmonth, effday, expmonth, expday"));
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static org.apache.commons.lang3.tuple.Pair<Long, Long> getDateMilliScope(String yearNum, long periodId) {
        Triple<Date, Date, Date> peiodStartEndAndYearStartDate = PeriodUtils.getPeiodStartEndAndYearStartDate(yearNum, periodId);
        return org.apache.commons.lang3.tuple.Pair.of((Object)((Date)peiodStartEndAndYearStartDate.getMiddle()).getTime(), (Object)((Date)peiodStartEndAndYearStartDate.getRight()).getTime());
    }

    public static Triple<Date, Date, Date> getPeiodStartEndAndYearStartDate(String yearNum, long periodId) {
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)periodId)});
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(yearNum), periodDyn.getInt("effmonth") - 1, periodDyn.getInt("effday"), 0, 0, 0);
        Timestamp startDate = new Timestamp(calendar.getTimeInMillis());
        startDate.setNanos(0);
        int expday = periodDyn.getInt("expday");
        expday = periodDyn.getInt("expmonth") == 2 && expday == 29 && !PeriodUtils.isLeapYear(Integer.parseInt(yearNum)) ? 28 : expday;
        calendar.set(Integer.parseInt(yearNum), periodDyn.getInt("expmonth") - 1, expday, 23, 59, 59);
        Timestamp endDate = new Timestamp(calendar.getTimeInMillis());
        endDate.setNanos(999);
        calendar.set(Integer.parseInt(yearNum), 0, 1, 0, 0, 0);
        Timestamp yearStartDate = new Timestamp(calendar.getTimeInMillis());
        yearStartDate.setNanos(0);
        return Triple.of((Object)yearStartDate, (Object)startDate, (Object)endDate);
    }

    public static boolean hasSystemPrefix(String number) {
        if ("LastPeriodX".equalsIgnoreCase(number)) {
            return true;
        }
        for (String prefix : array) {
            if (!number.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static Date getPeriodLastDate(Long modelId, String yearNum, String periodNum) {
        String year = yearNum.substring(2);
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter periodQf = new QFilter("number", "=", (Object)periodNum);
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (String)"expmonth,expday", (QFilter[])new QFilter[]{modelQf, periodQf});
        String month = periodDyn.getString("expmonth");
        String day = periodDyn.getString("expday");
        return PeriodUtils.getDate(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day));
    }

    public static Date getPeriodLastDate(String yearNum, Long periodId) {
        return (Date)ThreadCache.get((Object)Joiner.on((char)'|').join((Object)yearNum, (Object)periodId, new Object[0]), () -> {
            String year = "";
            year = yearNum.startsWith(FY_PREFIX) ? yearNum.substring(2) : DateUtils.getCurrentData().get(1) + "";
            DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bcm_periodmembertree");
            String month = periodDyn.getString("expmonth");
            String day = periodDyn.getString("expday");
            return PeriodUtils.getDate(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day));
        });
    }

    public static Date getPeriodLastDate(Long yearId, Long periodId) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("periodlastDate:" + yearId + "|" + periodId, () -> {
            DynamicObject yearDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)yearId, (String)"bcm_fymembertree");
            return PeriodUtils.getPeriodLastDate(yearDyn.getString("number"), periodId);
        });
    }

    public static Date getPeriodLastDate(long modelid, String yearNum, String periodNum) {
        QFilter qf = new QFilter("number", "=", (Object)periodNum);
        QFilter modelQf = new QFilter("model", "=", (Object)modelid);
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (String)"expmonth,expday", (QFilter[])new QFilter[]{qf, modelQf});
        String month = periodDyn.getString("expmonth");
        String day = periodDyn.getString("expday");
        return PeriodUtils.getDate(Integer.parseInt(yearNum.substring(2)), Integer.parseInt(month) - 1, Integer.parseInt(day));
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, 0, 0, 0);
        cal.set(14, 0);
        if (cal.get(2) > month) {
            cal.add(5, -1);
        }
        return cal.getTime();
    }

    public static String getYear(long yearId) {
        String year = "";
        DynamicObject yearDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)yearId, (String)"bcm_fymembertree");
        String yearNum = yearDyn.getString("number");
        if (yearNum.startsWith(FY_PREFIX)) {
            year = yearNum.substring(2);
        }
        return year;
    }

    public static boolean isInPeriod(Date[] inDate, Date[] outDate) {
        if (inDate == null || outDate == null || inDate.length != 2 || outDate.length != 2) {
            return false;
        }
        Date inBeginDate = inDate[0];
        Date inEndDate = inDate[1];
        Date outbeginDate = outDate[0];
        Date outEndDate = outDate[1];
        return inBeginDate.compareTo(outbeginDate) >= 0 && outEndDate.compareTo(inEndDate) >= 0;
    }

    public static long getYearByOffset(long modelId, int offset) {
        LocalDate date = LocalDate.now();
        int offsetYear = date.getYear() + offset;
        String yearFy = FY_PREFIX + offsetYear;
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id,number", (QFilter[])new QFBuilder().add("number", "=", yearFy).add("model.id", "=", modelId).toArray(), (String)"number desc", (int)1);
        if (coll.size() > 0) {
            return ((DynamicObject)coll.get(0)).getLong("id");
        }
        return 0L;
    }

    public static Tuple<Long, Long> getPeriodByOffset(long modelId, ScenarioMemberEnum scenario, long yearId, long periodId, int yearOffset, int periodOffset) {
        if (scenario == ScenarioMemberEnum.MRPT) {
            return PeriodUtils.getYearAndPeriodByOffset(P_M_01_PREFIX, modelId, yearId, periodId, yearOffset, periodOffset);
        }
        if (scenario == ScenarioMemberEnum.QRPT) {
            return PeriodUtils.getYearAndPeriodByOffset(P_Q_Q1_PREFIX, modelId, yearId, periodId, yearOffset, periodOffset);
        }
        if (scenario == ScenarioMemberEnum.SRPT) {
            return PeriodUtils.getYearAndPeriodByOffset(P_HF_HF1_PREFIX, modelId, yearId, periodId, yearOffset, periodOffset);
        }
        if (scenario == ScenarioMemberEnum.YDRPT) {
            return PeriodUtils.getYearAndPeriodByOffset(P_YD_D_PREFIX, modelId, yearId, periodId, yearOffset, periodOffset);
        }
        return PeriodUtils.getYearAndPeriodByOffset(P_M_01_PREFIX, modelId, yearId, periodId, yearOffset, periodOffset);
    }

    public static Tuple<Long, Long> getYearAndPeriodByOffset(String prefix, Long modelId, Long yearId, Long periodId, int yearOffset, int periodOffset) {
        int month;
        String modelNum = MemberReader.findModelNumberById(modelId);
        int day = 0;
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById(modelNum, periodId);
        IDNumberTreeNode yearNode = MemberReader.findFyMemberById(MemberReader.findModelNumberById(modelId), yearId);
        if (IDNumberTreeNode.NotFoundTreeNode == periodNode) {
            LocalDate date = LocalDate.now();
            month = date.getMonthValue();
            day = date.getDayOfMonth();
        } else {
            month = Integer.parseInt(periodNode.getProperty("effmonth").toString());
            day = Integer.parseInt(periodNode.getProperty("effday").toString());
        }
        int year = IDNumberTreeNode.NotFoundTreeNode == yearNode ? LocalDate.now().getYear() : Integer.parseInt(yearNode.getNumber().split(FY_PREFIX)[1]);
        int onePeriodMouthCount = 1;
        if (P_M_01_PREFIX.equals(prefix)) {
            String periodNumber = prefix.concat(String.format("%02d", month));
            if (periodOffset == 0 && IDNumberTreeNode.NotFoundTreeNode != periodNode) {
                periodNumber = periodNode.getNumber();
            }
            return PeriodUtils.getLastYearAndPeriodMouthByOffset(modelNum, FY_PREFIX + year, periodNumber, yearOffset, periodOffset);
        }
        if (P_Q_Q1_PREFIX.equals(prefix)) {
            onePeriodMouthCount = 3;
        } else if (P_HF_HF1_PREFIX.equals(prefix)) {
            onePeriodMouthCount = 6;
        } else if (P_YD_D_PREFIX.equals(prefix)) {
            if ((day += periodOffset) <= 0) {
                while (day <= 0) {
                    day += SysMembConstant.dayofMonth.get(--month).intValue();
                }
            } else {
                while (day > SysMembConstant.dayofMonth.get(month)) {
                    day -= SysMembConstant.dayofMonth.get(month).intValue();
                    if (periodOffset > 0) {
                        ++month;
                        continue;
                    }
                    --month;
                }
            }
            periodOffset = 0;
        }
        int oneYearPeriodCount = 12 / onePeriodMouthCount;
        int newPeriodIndex = month / onePeriodMouthCount + periodOffset + (month % onePeriodMouthCount > 0 ? 1 : 0);
        int newYearIndex = yearOffset + year;
        while (newPeriodIndex > oneYearPeriodCount) {
            newPeriodIndex -= oneYearPeriodCount;
            ++newYearIndex;
        }
        while (newPeriodIndex <= 0) {
            newPeriodIndex += oneYearPeriodCount;
            --newYearIndex;
        }
        String newYearStr = FY_PREFIX + newYearIndex;
        String newPeriodStr = "";
        newPeriodStr = P_YD_D_PREFIX.equals(prefix) ? prefix.concat(String.format("%02d", newPeriodIndex)).concat(String.format("%02d", day)) : (P_Q_Q1_PREFIX.equals(prefix) || P_HF_HF1_PREFIX.equals(prefix) ? prefix.concat(String.valueOf(newPeriodIndex)) : prefix.concat(String.format("%02d", newPeriodIndex)));
        IDNumberTreeNode newPeriodNode = MemberReader.findPeriodMemberByNum(modelNum, newPeriodStr);
        IDNumberTreeNode newYearNode = MemberReader.findFyMemberByNum(MemberReader.findModelNumberById(modelId), newYearStr);
        return new Tuple((Object)newYearNode.getId(), (Object)(periodOffset == 0 && periodId != 0L ? periodId : newPeriodNode.getId()));
    }

    private static Tuple<Long, Long> getLastYearAndPeriodMouthByOffset(String modelNum, String yearNum, String periodNum, int yearOffset, int periodOffset) {
        Optional<String> yearOp;
        while (yearOffset < 0) {
            yearOp = PeriodUtils.getLastYear(modelNum, yearNum);
            if (yearOp.isPresent()) {
                yearNum = yearOp.get();
                ++yearOffset;
                continue;
            }
            return new Tuple((Object)0L, (Object)0L);
        }
        while (periodOffset < 0) {
            Optional<String> periodOp = PeriodUtils.getLastPeriod(modelNum, yearNum, periodNum, true);
            if (periodOp.isPresent()) {
                if (PeriodUtils.isFirstPeriod(modelNum, periodNum) && (yearOp = PeriodUtils.getLastYear(modelNum, yearNum)).isPresent()) {
                    yearNum = yearOp.get();
                }
                periodNum = periodOp.get();
                ++periodOffset;
                continue;
            }
            return new Tuple((Object)0L, (Object)0L);
        }
        IDNumberTreeNode newPeriodNode = MemberReader.findPeriodMemberByNum(modelNum, periodNum);
        IDNumberTreeNode newYearNode = MemberReader.findFyMemberByNum(modelNum, yearNum);
        return new Tuple((Object)newYearNode.getId(), (Object)newPeriodNode.getId());
    }

    public static List<String> getAfterPeriod(String cube, String period) {
        if (!period.startsWith(P_M_01_PREFIX)) {
            return new ArrayList<String>();
        }
        ArrayList<String> M_M = new ArrayList<String>();
        MemberReader.getAllNodeByDimNum(DimTypesEnum.PERIOD.getNumber(), cube).forEach(p -> {
            if (p.getNumber().startsWith(P_M_01_PREFIX) && period.compareTo(p.getNumber()) < 0) {
                M_M.add(p.getNumber());
            }
        });
        return M_M;
    }

    public static Optional<String> getLastPeriod(String modelNum, String yearNum, String periodNum, boolean isIncludeAdjPeriod) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache(modelNum + "|" + yearNum + "|" + periodNum + "|" + isIncludeAdjPeriod, () -> {
            String lastNum;
            if (!periodNum.startsWith(P_M_01_PREFIX) || StringUtils.isEmpty((String)yearNum) || !isIncludeAdjPeriod) {
                return PeriodUtils.getLastPeriod(modelNum, periodNum, isIncludeAdjPeriod);
            }
            if (StringUtils.isEmpty((String)modelNum) || StringUtils.isEmpty((String)periodNum)) {
                return Optional.empty();
            }
            Optional<IDNumberTreeNode> currentPeriod = PeriodUtils.getNodeByNumber(modelNum, periodNum);
            if (!currentPeriod.isPresent()) {
                return Optional.empty();
            }
            IDNumberTreeNode currentNode = currentPeriod.get();
            if (((Boolean)currentNode.getProperty("isadjust")).booleanValue()) {
                currentNode = PeriodUtils.getNodeByNumber(modelNum, (String)currentNode.getProperty("relatednumber")).get();
            }
            if ("M_M00".equals(lastNum = (String)currentNode.getProperty("lastperiod"))) {
                return Optional.empty();
            }
            if (PeriodUtils.isStandardMonthPeriod(lastNum)) {
                return Optional.ofNullable(lastNum);
            }
            Optional<IDNumberTreeNode> lastPeriod = PeriodUtils.getNodeByNumber(modelNum, lastNum);
            String newYearNum = "M_M01".equals(currentNode.getNumber()) ? (String)PeriodUtils.getLastYear(modelNum, yearNum).orElse(null) : yearNum;
            String lastStandardMonth = PeriodUtils.getLastStandardMonth(currentNode.getNumber());
            if (StringUtils.isEmpty((String)newYearNum) || StringUtils.isEmpty((String)lastStandardMonth)) {
                return Optional.empty();
            }
            List<IDNumberTreeNode> lastPeriods = PeriodUtils.getAdjustByRelatedNum(modelNum, lastStandardMonth);
            if (lastPeriod.isPresent()) {
                IDNumberTreeNode lastNode = lastPeriod.get();
                String useYear = (String)lastNode.getProperty("useyear");
                if (StringUtils.isNotEmpty((String)useYear) && useYear.contains(newYearNum)) {
                    return Optional.ofNullable(lastNode.getNumber());
                }
                String tmpPeriod = null;
                for (IDNumberTreeNode period : lastPeriods) {
                    useYear = (String)period.getProperty("useyear");
                    if (StringUtils.isEmpty((String)useYear)) continue;
                    if (period.getdSeq() < lastNode.getdSeq() && useYear.contains(newYearNum)) {
                        return Optional.ofNullable(period.getNumber());
                    }
                    if (period.getdSeq() < lastNode.getdSeq() || !useYear.contains(newYearNum)) continue;
                    tmpPeriod = period.getNumber();
                }
                if (tmpPeriod != null) {
                    return Optional.ofNullable(tmpPeriod);
                }
                return Optional.ofNullable(lastStandardMonth);
            }
            for (IDNumberTreeNode period : lastPeriods) {
                String useYear = (String)period.getProperty("useyear");
                if (!PeriodUtils.isStandardMonthPeriod(period.getNumber()) && (!StringUtils.isNotEmpty((String)useYear) || !useYear.contains(newYearNum))) continue;
                return Optional.ofNullable(period.getNumber());
            }
            return Optional.empty();
        });
    }

    public static Optional<IDNumberTreeNode> getNodeByNumber(String modelNum, String periodNum) {
        return MemberReader.getAllNodeByDimNum(DimTypesEnum.PERIOD.getNumber(), modelNum).stream().filter(p -> p.getNumber().equals(periodNum)).findFirst();
    }

    public static List<IDNumberTreeNode> getAdjustByRelatedNum(String modelNum, String relatedNum) {
        List<IDNumberTreeNode> periods = MemberReader.getAllNodeByDimNum(DimTypesEnum.PERIOD.getNumber(), modelNum).stream().filter(p -> relatedNum.equals(p.getProperty("relatednumber")) || relatedNum.equals(p.getNumber())).collect(Collectors.toList());
        periods.sort(Comparator.comparingInt(IDNumberTreeNode::getdSeq).reversed());
        return periods;
    }

    public static boolean isStandardMonthPeriod(String number) {
        return STANDARD_MONTH_PERIOD_SET.contains(number);
    }

    public static String getLastStandardMonth(String periodNum) {
        if ("M_M01".equals(periodNum)) {
            return "M_M12";
        }
        if ("M_M00".equals(periodNum)) {
            return null;
        }
        int index = STANDARD_MONTH_PERIOD.indexOf(periodNum);
        if (index > 0) {
            return STANDARD_MONTH_PERIOD.get(index - 1);
        }
        return null;
    }

    public static Set<Long> getPeriodByScene(long modelId, long sceneId) {
        HashSet<Long> periodIds = new HashSet<Long>(16);
        DynamicObjectCollection col = (DynamicObjectCollection)BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"id,sceneperiod", (QFilter[])new QFBuilder("id", "=", sceneId).toArray()).get("sceneperiod");
        if (col != null) {
            col.forEach(e -> {
                if (e.getDynamicObject("fbasedataid") != null) {
                    periodIds.add(e.getDynamicObject("fbasedataid").getLong("id"));
                }
            });
        }
        return periodIds;
    }
}

