/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.fi.bcm.common.enums.SpreadSelectTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;

public class SpreadAreaUtil {
    public static boolean isInArea(String selector, List<String> areas) {
        return areas.stream().anyMatch(area -> SpreadAreaUtil.getRangModel(selector).checkIsInArea(SpreadAreaUtil.getRangModel(area)));
    }

    public static boolean isInArea(String selector, String area) {
        return SpreadAreaUtil.getRangModel(selector).checkIsInArea(SpreadAreaUtil.getRangModel(area));
    }

    public static boolean isRowInArea(int idx, String area) {
        return SpreadAreaUtil.getRangModel(area).isRowInArea(idx);
    }

    public static boolean isColInArea(int idx, String area) {
        return SpreadAreaUtil.getRangModel(area).isColInArea(idx);
    }

    public static Collection<String> getRow(String area) {
        return SpreadAreaUtil.getRangModel(area).spiltToRow();
    }

    public static Collection<String> getCol(String area) {
        return SpreadAreaUtil.getRangModel(area).spiltToCol();
    }

    public static String getRowGreen(String area) {
        return String.valueOf(SpreadAreaUtil.getRangModel(area).getY_start() + 1);
    }

    public static String getColGreen(String area) {
        return ExcelUtils.int2pos(SpreadAreaUtil.getRangModel(area).getX_start());
    }

    public static int[] getGreenIndex(String area) {
        RangeModel rangeModel = SpreadAreaUtil.getRangModel(area);
        int[] indexs = new int[]{rangeModel.getX_start(), rangeModel.getY_start(), rangeModel.getX_end(), rangeModel.getY_end()};
        return indexs;
    }

    public static String getRemoveCoordinate(String coordinate) {
        return SpreadAreaUtil.getRangModel(coordinate).getLeft_UpOne(1, 1);
    }

    public static String getRemoveCoordinate(String coordinate, int rowOffset, int colOffset) {
        return SpreadAreaUtil.getRangModel(coordinate).getLeft_UpOne(rowOffset, colOffset);
    }

    public static SpreadSelectTypeEnum selectedInArea(String select, String startpoint, String area) {
        RangeModel area_startpoint;
        RangeModel startpoint_coordinate = SpreadAreaUtil.getRangModel(startpoint);
        RangeModel select_coordinate = SpreadAreaUtil.getRangModel(select);
        if (!select_coordinate.checkIsInArea(area_startpoint = SpreadAreaUtil.getRangModel(area))) {
            return SpreadSelectTypeEnum.NOT_IN;
        }
        if (select_coordinate.getX_end() < startpoint_coordinate.getX_start()) {
            if (select_coordinate.getY_end() < startpoint_coordinate.getY_start()) {
                return SpreadSelectTypeEnum.LEFT_TOP;
            }
            if (select_coordinate.getY_start() > startpoint_coordinate.getY_end()) {
                return SpreadSelectTypeEnum.LEFT_BOTTOM;
            }
        } else if (select_coordinate.getX_start() > startpoint_coordinate.getX_end()) {
            if (select_coordinate.getY_end() < startpoint_coordinate.getY_start()) {
                return SpreadSelectTypeEnum.RIGHT_TOP;
            }
            if (select_coordinate.getY_start() > startpoint_coordinate.getY_end()) {
                return SpreadSelectTypeEnum.RIGHT__BOTTOM;
            }
        }
        return SpreadSelectTypeEnum.ILLEGAL;
    }

    public static boolean Area_Contains(String need_coordinate, Collection<String> coordinates) {
        Set<String> x = SpreadAreaUtil.getRangModel(need_coordinate).getCombination();
        for (String s : coordinates) {
            Set<String> y = SpreadAreaUtil.getRangModel(s).getCombination();
            for (String xx : x) {
                if (!y.contains(xx)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean Area_contains_xy(String need_coordinate, Collection<String> coordinates, SpreadSelectTypeEnum areainwhere) {
        RangeModel need = SpreadAreaUtil.getRangModel(need_coordinate);
        for (String s : coordinates) {
            RangeModel coo = SpreadAreaUtil.getRangModel(s);
            if (!(SpreadSelectTypeEnum.LEFT_BOTTOM == areainwhere ? need.getY_start() <= coo.getY_end() && coo.getY_start() <= need.getY_end() : SpreadSelectTypeEnum.RIGHT_TOP == areainwhere && need.getX_start() <= coo.getX_end() && coo.getX_start() <= need.getX_end())) continue;
            return true;
        }
        return false;
    }

    public static RangeModel getRangModel(String coordinate) {
        return new RangeModel(coordinate);
    }

    public static boolean isUpArea(String area1, String area2) {
        RangeModel a1 = new RangeModel(area1);
        RangeModel a2 = new RangeModel(area2);
        return a1.getY_end() < a2.getY_start();
    }

    public static boolean isLeftArea(String area1, String area2) {
        RangeModel a1 = new RangeModel(area1);
        RangeModel a2 = new RangeModel(area2);
        return a1.getX_end() < a2.getX_start();
    }

    public static SpreadSelectTypeEnum selectedInCanFloatArea(String select, String startpoint, String area) {
        RangeModel area_startpoint;
        area = "A1:" + area.split(":")[1];
        RangeModel startpoint_coordinate = SpreadAreaUtil.getRangModel(startpoint);
        RangeModel select_coordinate = SpreadAreaUtil.getRangModel(select);
        if (!select_coordinate.checkIsInArea(area_startpoint = SpreadAreaUtil.getRangModel(area))) {
            return SpreadSelectTypeEnum.NOT_IN;
        }
        if (select_coordinate.getX_end() < startpoint_coordinate.getX_start()) {
            if (select_coordinate.getY_end() < startpoint_coordinate.getY_start()) {
                return SpreadSelectTypeEnum.LEFT_TOP;
            }
            if (select_coordinate.getY_start() >= startpoint_coordinate.getY_end()) {
                return SpreadSelectTypeEnum.LEFT_BOTTOM;
            }
        } else if (select_coordinate.getX_start() >= startpoint_coordinate.getX_end()) {
            if (select_coordinate.getY_end() < startpoint_coordinate.getY_start()) {
                return SpreadSelectTypeEnum.RIGHT_TOP;
            }
            if (select_coordinate.getY_start() > startpoint_coordinate.getY_end()) {
                return SpreadSelectTypeEnum.RIGHT__BOTTOM;
            }
        }
        return SpreadSelectTypeEnum.ILLEGAL;
    }

    public static int calcAreaRowAmount(String area) {
        RangeModel rangeModel = SpreadAreaUtil.getRangModel(area);
        return rangeModel.getY_end() - rangeModel.getY_start() + 1;
    }

    public static boolean matchRowsInArea(List<Integer> operationdata, PositionInfo positionInfo) {
        String areaRange = positionInfo.getAreaRange();
        RangeModel areaRangeModel = SpreadAreaUtil.getRangModel(areaRange);
        for (Integer data : operationdata) {
            if (data >= areaRangeModel.getY_start() && data <= areaRangeModel.getY_end()) {
                return true;
            }
            for (BasePointInfo basePoint : positionInfo.getBasePoints()) {
                String floatRange = basePoint.getDynaRange();
                RangeModel floatRangeModel = SpreadAreaUtil.getRangModel(floatRange);
                if (data < floatRangeModel.getY_start() || data > floatRangeModel.getY_end()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matchColsInArea(List<Integer> operationdata, PositionInfo positionInfo) {
        String areaRange = positionInfo.getAreaRange();
        RangeModel areaRangeModel = SpreadAreaUtil.getRangModel(areaRange);
        for (Integer data : operationdata) {
            if (data >= areaRangeModel.getX_start() && data <= areaRangeModel.getX_end()) {
                return true;
            }
            for (BasePointInfo basePoint : positionInfo.getBasePoints()) {
                String floatRange = basePoint.getDynaRange();
                RangeModel floatRangeModel = SpreadAreaUtil.getRangModel(floatRange);
                if (data < floatRangeModel.getX_start() || data > floatRangeModel.getX_end()) continue;
                return true;
            }
        }
        return false;
    }
}

