/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.bos.zip.ZipFile;
import kd.bos.zip.model.ZipParameters;
import kd.bos.zip.model.enums.CompressionLevel;
import kd.bos.zip.model.enums.CompressionMethod;
import kd.bos.zip.model.enums.EncryptionMethod;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class ZipFileUtil {
    private static final int BUFFER = 512;
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ZipFileUtil.class);

    private static List<File> getAllFiles(File srcFile) {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] tmp = srcFile.listFiles();
        if (tmp != null) {
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i].isFile()) {
                    fileList.add(tmp[i]);
                }
                if (!tmp[i].isDirectory()) continue;
                if (tmp[i].listFiles().length != 0) {
                    fileList.addAll(ZipFileUtil.getAllFiles(tmp[i]));
                    continue;
                }
                fileList.add(tmp[i]);
            }
        }
        return fileList;
    }

    private static String getRelativePath(String dirPath, File file) {
        File dir = new File(dirPath);
        String relativePath = file.getName();
        while ((file = file.getParentFile()) != null && !file.equals(dir)) {
            relativePath = file.getName() + File.separator + relativePath;
        }
        return relativePath;
    }

    private static File createFile(String dstPath, String fileName) throws IOException {
        String[] dirs = fileName.split("/");
        File file = new File(dstPath);
        if (dirs.length > 1) {
            for (int i = 0; i < dirs.length - 1; ++i) {
                file = new File(file, dirs[i]);
            }
            if (!file.exists()) {
                file.mkdirs();
            }
            file = new File(file, dirs[dirs.length - 1]);
            return file;
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        file = new File(file, dirs[0]);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzip(String zipFileName, String dstPath) {
        OutputStream outputStream = null;
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFileName));){
            ZipEntry zipEntry = null;
            byte[] buffer = new byte[512];
            int readLength = 0;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File dir;
                if (zipEntry.isDirectory() && !(dir = new File(dstPath + "/" + zipEntry.getName())).exists()) {
                    dir.mkdirs();
                    continue;
                }
                File file = ZipFileUtil.createFile(dstPath, zipEntry.getName());
                outputStream = new FileOutputStream(file);
                while ((readLength = zipInputStream.read(buffer, 0, 512)) != -1) {
                    outputStream.write(buffer, 0, readLength);
                }
                outputStream.close();
            }
        }
        catch (FileNotFoundException e) {
            logger.error(e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static String unzipByPwd(String dstPath, ZipFile zipFile, String cypher) {
        try {
            zipFile.setPassword(cypher.toCharArray());
            zipFile.extractAll(dstPath);
        }
        catch (Exception e) {
            logger.error(e);
            return ResManager.loadKDString((String)"zip\u6587\u4ef6\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u9a8c\u8bc1\u5bc6\u7801\u3002", (String)"ZipFileUtil_0", (String)"fi-bcm-common", (Object[])new Object[0]);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zip(String srcPath, String zipFileName) {
        File srcFile = new File(srcPath);
        List<File> fileList = ZipFileUtil.getAllFiles(srcFile);
        byte[] buffer = new byte[512];
        ZipEntry zipEntry = null;
        int readLength = 0;
        InputStream inputStream = null;
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFileName));){
            for (File file : fileList) {
                if (file.isFile()) {
                    zipEntry = new ZipEntry(ZipFileUtil.getRelativePath(srcPath, file));
                    zipEntry.setSize(file.length());
                    zipEntry.setTime(file.lastModified());
                    zipOutputStream.putNextEntry(zipEntry);
                    inputStream = new BufferedInputStream(new FileInputStream(file));
                    while ((readLength = inputStream.read(buffer, 0, 512)) != -1) {
                        zipOutputStream.write(buffer, 0, readLength);
                    }
                    inputStream.close();
                    continue;
                }
                zipEntry = new ZipEntry(ZipFileUtil.getRelativePath(srcPath, file) + "/");
                zipOutputStream.putNextEntry(zipEntry);
            }
        }
        catch (FileNotFoundException e) {
            logger.error(e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static File zipByPwd(String srcPath, String zipFileName, String secretkey) {
        File srcFile = new File(srcPath);
        List<File> fileList = ZipFileUtil.getAllFiles(srcFile);
        ZipFile secretZip = new ZipFile(zipFileName);
        try {
            ZipParameters zipParameters = new ZipParameters();
            boolean isSecret = !StringUtils.isEmpty((String)secretkey);
            zipParameters.setEncryptFiles(isSecret);
            if (isSecret) {
                zipParameters.setCompressionMethod(CompressionMethod.DEFLATE);
                zipParameters.setCompressionLevel(CompressionLevel.NORMAL);
                zipParameters.setEncryptionMethod(EncryptionMethod.AES);
                secretZip.setPassword(secretkey.toCharArray());
            }
            secretZip.createSplitZipFile(fileList, zipParameters, false, -1L);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new KDBizException(e.getMessage());
        }
        return secretZip.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipOfApa(String zipFileName, String descDir) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ZipArchiveInputStream inputStream = null;
        try {
            fis = new FileInputStream(zipFileName);
            bis = new BufferedInputStream(fis);
            inputStream = new ZipArchiveInputStream((InputStream)bis);
            File pathFile = new File(descDir);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            ZipArchiveEntry entry = null;
            int readLength = 0;
            byte[] buffer = new byte[512];
            while ((entry = inputStream.getNextZipEntry()) != null) {
                if (entry.isDirectory()) {
                    File directory = new File(descDir, entry.getName());
                    directory.mkdirs();
                    continue;
                }
                OutputStream os = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(new File(descDir, entry.getName())));
                    logger.info("\u89e3\u538b\u6587\u4ef6\u7684\u5f53\u524d\u8def\u5f84\u4e3a:" + descDir + entry.getName());
                    while ((readLength = inputStream.read(buffer, 0, 512)) != -1) {
                        os.write(buffer, 0, readLength);
                    }
                }
                finally {
                    if (os == null) continue;
                    os.close();
                }
            }
            logger.info("******************\u89e3\u538b\u5b8c\u6bd5********************");
        }
        catch (Exception e) {
            try {
                logger.error("[unzip] \u89e3\u538bzip\u6587\u4ef6\u51fa\u9519", e);
            }
            catch (Throwable throwable) {
                ZipFileUtil.closeStream(inputStream);
                ZipFileUtil.closeStream(bis);
                ZipFileUtil.closeStream(fis);
                throw throwable;
            }
            ZipFileUtil.closeStream(inputStream);
            ZipFileUtil.closeStream(bis);
            ZipFileUtil.closeStream(fis);
        }
        ZipFileUtil.closeStream((Closeable)inputStream);
        ZipFileUtil.closeStream(bis);
        ZipFileUtil.closeStream(fis);
    }

    private static void closeStream(Closeable closeStream) {
        if (closeStream != null) {
            try {
                closeStream.close();
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u51fa\u9519\u3002", e);
            }
        }
    }
}

