/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.common;

import java.io.File;
import java.math.BigDecimal;
import java.util.HashSet;
import kd.fi.bcm.fel.FelEngine;
import kd.fi.bcm.fel.FelEngineImpl;
import kd.fi.bcm.fel.function.FunMgr;
import kd.fi.bcm.fel.function.operator.big.BigAdd;
import kd.fi.bcm.fel.function.operator.big.BigDiv;
import kd.fi.bcm.fel.function.operator.big.BigGreaterThan;
import kd.fi.bcm.fel.function.operator.big.BigGreaterThanEqual;
import kd.fi.bcm.fel.function.operator.big.BigLessThan;
import kd.fi.bcm.fel.function.operator.big.BigLessThanEqual;
import kd.fi.bcm.fel.function.operator.big.BigMod;
import kd.fi.bcm.fel.function.operator.big.BigMul;
import kd.fi.bcm.fel.function.operator.big.BigSub;
import kd.fi.bcm.fel.parser.AntlrParser;
import kd.fi.bcm.fel.parser.NodeAdaptor;
import kd.fi.bcm.fel.security.RegexSecurityMgr;
import kd.fi.bcm.fel.security.SecurityMgr;

public class FelBuilder {
    private static final char[] LAST_CHARS = new char[]{'l', 'L', 'd', 'D', 'f', 'F'};

    public static SecurityMgr newSecurityMgr() {
        HashSet<String> disables = new HashSet<String>();
        disables.add(System.class.getCanonicalName() + ".*");
        disables.add(Runtime.class.getCanonicalName() + ".*");
        disables.add(Process.class.getCanonicalName() + ".*");
        disables.add(File.class.getCanonicalName() + ".*");
        disables.add("java.net.*");
        disables.add("com.greenpineyu.fel.compile.*");
        disables.add("com.greenpineyu.fel.security.*");
        return new RegexSecurityMgr(null, disables);
    }

    public static FelEngine bigNumberEngine() {
        return FelBuilder.bigNumberEngine(100);
    }

    public static FelEngine engine() {
        return new FelEngineImpl();
    }

    public static FelEngine bigNumberEngine(int setPrecision) {
        FelEngineImpl engine = new FelEngineImpl();
        FunMgr funMgr = engine.getFunMgr();
        engine.setParser(new AntlrParser(engine, new NodeAdaptor(){

            @Override
            protected Number newFloatNumber(String text) {
                char lastChar = text.charAt(text.length() - 1);
                for (char c : LAST_CHARS) {
                    if (lastChar != c) continue;
                    text = text.substring(0, text.length() - 1);
                    break;
                }
                return new BigDecimal(text);
            }
        }));
        funMgr.add(new BigAdd());
        funMgr.add(new BigSub());
        funMgr.add(new BigMul());
        funMgr.add(new BigDiv(setPrecision));
        funMgr.add(new BigMod());
        funMgr.add(new BigGreaterThan());
        funMgr.add(new BigGreaterThanEqual());
        funMgr.add(new BigLessThan());
        funMgr.add(new BigLessThanEqual());
        return engine;
    }
}

