/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.bcm.fel.common.ArrayUtils;
import kd.fi.bcm.fel.function.operator.Add;

public class NumberUtil {
    public static final BigDecimal BIGD_DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal BIGD_DOUBLE_MIN_VALUE = BigDecimal.valueOf(Double.MIN_VALUE);
    public static final BigInteger BIGI_LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger BIGI_LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);

    public static boolean toBoolean(Object val) {
        return NumberUtil.toBooleanObj(val);
    }

    public static Boolean toBooleanObj(Object val) {
        if (val == null) {
            return Boolean.FALSE;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return Boolean.valueOf((String)val);
        }
        return Boolean.FALSE;
    }

    public static int toInteger(Object val) {
        if (val == null) {
            throw new IllegalArgumentException("Integer coercion exception. arg is null");
        }
        if (val instanceof String) {
            if ("".equals(val)) {
                return 0;
            }
            return Integer.parseInt((String)val);
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val instanceof Boolean) {
            throw new IllegalArgumentException("Boolean->Integer coercion exception");
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        throw new IllegalArgumentException("Integer coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public static long toLong(Object val) {
        if (val == null) {
            throw new NumberFormatException("Long coercion exception. arg is null");
        }
        if (val instanceof String) {
            if ("".equals(val)) {
                return 0L;
            }
            return Long.parseLong((String)val);
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val instanceof Boolean) {
            throw new NumberFormatException("Boolean->Long coercion exception");
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        throw new NumberFormatException("Long coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public static BigInteger toBigInteger(Object val) {
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        if (val == null) {
            throw new IllegalArgumentException("BigInteger coercion exception. arg is null");
        }
        if (val instanceof String) {
            String string = (String)val;
            if ("".equals(string.trim())) {
                return BigInteger.ZERO;
            }
            return new BigInteger(string);
        }
        if (val instanceof Number) {
            return new BigInteger(val.toString());
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return BigInteger.valueOf(i);
        }
        throw new IllegalArgumentException("BigInteger coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public static BigDecimal toBigDecimal(Object val) {
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val == null) {
            throw new IllegalArgumentException("BigDecimal coercion exception. arg is null");
        }
        if (val instanceof String) {
            String string = (String)val;
            if ("".equals(string.trim())) {
                return BigDecimal.valueOf(0L);
            }
            return new BigDecimal(string);
        }
        if (val instanceof Number) {
            return new BigDecimal(val.toString());
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return new BigDecimal(i);
        }
        throw new IllegalArgumentException("BigDecimal coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public static double toDouble(Object val) {
        if (val == null) {
            throw new IllegalArgumentException("Double coercion exception. arg is null");
        }
        if (val instanceof String) {
            String string = (String)val;
            if ("".equals(string.trim())) {
                return 0.0;
            }
            return Double.parseDouble(string);
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return i;
        }
        if (val instanceof Number) {
            return NumberUtil.toDouble((Number)val);
        }
        if (val instanceof Boolean) {
            throw new IllegalArgumentException("Boolean->Double coercion exception");
        }
        throw new IllegalArgumentException("Double coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public static Number narrow(Number original) {
        BigDecimal bigd;
        if (original == null) {
            return original;
        }
        Number result = original;
        if (original instanceof BigDecimal && (bigd = (BigDecimal)original).compareTo(BIGD_DOUBLE_MAX_VALUE) > 0) {
            return original;
        }
        if (original instanceof Double || original instanceof Float || original instanceof BigDecimal) {
            double value = original.doubleValue();
            if (value <= 3.4028234663852886E38 && value >= (double)1.4E-45f) {
                result = Float.valueOf(result.floatValue());
            }
        } else {
            BigInteger bigi;
            if (original instanceof BigInteger && ((bigi = (BigInteger)original).compareTo(BIGI_LONG_MAX_VALUE) > 0 || bigi.compareTo(BIGI_LONG_MIN_VALUE) < 0)) {
                return original;
            }
            long value = original.longValue();
            return NumberUtil.parseNumber(value);
        }
        return result;
    }

    public static boolean isFloatingPointNumber(Object val) {
        if (val instanceof Float || val instanceof Double) {
            return true;
        }
        if (val instanceof String) {
            String string = (String)val;
            return string.indexOf(46) != -1 || string.indexOf(101) != -1 || string.indexOf(69) != -1;
        }
        return false;
    }

    public static boolean isFloatingPoint(Object o) {
        return o instanceof Float || o instanceof Double;
    }

    public static boolean isNumberable(Object o) {
        return o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Short || o instanceof Character;
    }

    public static Number narrowBigInteger(Object lhs, Object rhs, BigInteger bigi) {
        if (!(lhs instanceof BigInteger) && !(rhs instanceof BigInteger) && bigi.compareTo(BIGI_LONG_MAX_VALUE) <= 0 && bigi.compareTo(BIGI_LONG_MIN_VALUE) >= 0) {
            long l = bigi.longValue();
            if (!(lhs instanceof Long) && !(rhs instanceof Long) && l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return Integer.valueOf(l + "");
            }
            return Long.valueOf(l + "");
        }
        return bigi;
    }

    public static boolean narrowArguments(Object[] args) {
        boolean narrowed = false;
        for (int a = 0; a < args.length; ++a) {
            Object arg = args[a];
            if (!(arg instanceof Number)) continue;
            Number narg = NumberUtil.narrow((Number)arg);
            if (narg != arg) {
                narrowed = true;
            }
            args[a] = narg;
        }
        return narrowed;
    }

    public static Number parseNumber(long l) {
        int i = (int)l;
        if ((long)i == l) {
            return i;
        }
        return l;
    }

    public static Object parseNumber(double d) {
        long f = (long)d;
        if ((double)f == d) {
            return NumberUtil.parseNumber(f);
        }
        return d;
    }

    public static Object parseNumber(String str) {
        if (str != null) {
            String trimValue = str.trim();
            try {
                return NumberUtil.parseNumber(Double.parseDouble(trimValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static double toDouble(Number number) {
        if (number instanceof Float) {
            return Double.parseDouble(number.toString());
        }
        return number.doubleValue();
    }

    public static <T extends Comparable<T>> int compare(T a, T b) {
        if (a != null && b != null) {
            return a.compareTo(b);
        }
        return a == null ? -1 : 1;
    }

    public static Object calArray(Object obj) {
        if (!(obj instanceof Object[])) {
            return obj;
        }
        Object result = 0;
        if (!ArrayUtils.isEmpty((Object[])obj)) {
            for (int i = 0; i < ((Object[])obj).length; ++i) {
                result = Add.add(result, ((Object[])obj)[i]);
            }
        }
        return result;
    }

    public static Class<?> arithmeticClass(Class<?> left, Class<?> right) {
        if (NumberUtil.isDoubleClass(left) || NumberUtil.isDoubleClass(right)) {
            return Double.TYPE;
        }
        if (NumberUtil.isLongClass(left) || NumberUtil.isLongClass(right)) {
            return Long.TYPE;
        }
        return Integer.TYPE;
    }

    public static boolean isDoubleClass(Class<?> type) {
        return type == Double.class || type == Double.TYPE;
    }

    public static boolean isLongClass(Class<?> type) {
        return type == Long.class || type == Long.TYPE;
    }

    public static boolean equals(double left, float right) {
        return left == NumberUtil.toDouble(Float.valueOf(right));
    }

    public static boolean equals(float left, double right) {
        return NumberUtil.toDouble(Float.valueOf(left)) == right;
    }

    public static boolean equals(float left, float right) {
        return NumberUtil.isEqual(left, right);
    }

    public static boolean equals(double left, double right) {
        return NumberUtil.isEqual(left, right);
    }

    public static boolean equals(long left, int right) {
        return left == (long)right;
    }

    public static boolean equals(int left, long right) {
        return (long)left == right;
    }

    public static boolean equals(int left, int right) {
        return left == right;
    }

    public static boolean equals(long left, long right) {
        return left == right;
    }

    public static boolean isEqual(float a, float b) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isInfinite(a) || Double.isInfinite(b)) {
            return false;
        }
        double eps = 1.0E-8;
        return (double)Math.abs(a - b) < eps;
    }

    public static boolean isEqual(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isInfinite(a) || Double.isInfinite(b)) {
            return false;
        }
        double eps = 1.0E-8;
        return Math.abs(a - b) < eps;
    }

    public static Object convertNullObjectAsBase(Object base) {
        return NumberUtil.formatResult(base);
    }

    private static Object formatResult(Object base) {
        if (base instanceof Number) {
            return BigDecimal.ZERO;
        }
        if (base instanceof String) {
            return "";
        }
        return null;
    }

    public static Object outputData(Object right) {
        return right instanceof String ? String.format("%s%s%s", "\"", right, "\"") : right;
    }

    public static boolean isNumeric(String numberStr) {
        if (StringUtils.isEmpty((CharSequence)numberStr)) {
            return false;
        }
        try {
            Float.parseFloat(numberStr);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

