/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.common;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.fi.bcm.fel.common.ArrayUtils;
import kd.fi.bcm.fel.common.Null;

public class ReflectUtil {
    private static final Map<Class<?>, Class<?>> wrapperCls;
    private static final Map<Class<?>, Class<?>> primitiveCls;
    private static final Map<Class<?>, Class<?>> numberClassMap;

    private static Map<Class<?>, Class<?>> primitiveNumberCls() {
        HashMap map = new HashMap();
        map.put(Byte.TYPE, Byte.TYPE);
        map.put(Byte.class, Byte.TYPE);
        map.put(Short.TYPE, Short.TYPE);
        map.put(Short.class, Short.TYPE);
        map.put(Integer.TYPE, Integer.TYPE);
        map.put(Integer.class, Integer.TYPE);
        map.put(Long.TYPE, Long.TYPE);
        map.put(Long.class, Long.TYPE);
        map.put(Float.TYPE, Float.TYPE);
        map.put(Float.class, Float.TYPE);
        map.put(Double.TYPE, Double.TYPE);
        map.put(Double.class, Double.TYPE);
        map.put(Character.TYPE, Character.TYPE);
        map.put(Character.class, Character.TYPE);
        return map;
    }

    private static Map<Class<?>, Class<?>> wrapperNumberCls() {
        HashMap map = new HashMap();
        map.put(Byte.TYPE, Byte.class);
        map.put(Byte.class, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Short.class, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Integer.class, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Long.class, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Float.class, Float.class);
        map.put(Double.TYPE, Double.class);
        map.put(Double.class, Double.class);
        map.put(Character.TYPE, Character.class);
        map.put(Character.class, Character.class);
        return map;
    }

    public static boolean isFloatingPointNumber(Object obj) {
        return obj instanceof Float || obj instanceof Double;
    }

    public static boolean isFloatType(Class<?> t) {
        return t == Float.TYPE || t == Float.class;
    }

    public static boolean isDoubleType(Class<?> t) {
        return t == Double.TYPE || t == Double.class;
    }

    public static boolean isPrimitiveOrWrapNumber(Class<?> c) {
        return numberClassMap.containsKey(c);
    }

    public static boolean isPrimitiveNumber(Class<?> c) {
        if (c == null) {
            return false;
        }
        return c.isPrimitive() && c != Boolean.TYPE;
    }

    public static Class<?> toWrapperClass(Class<?> c) {
        return wrapperCls.get(c);
    }

    public static Class<?> toPrimitiveClass(Class<?> c) {
        return primitiveCls.get(c);
    }

    public static void sort(int[] array) {
        for (int i = 1; i < array.length; ++i) {
            int current = array[i];
            for (int j = i - 1; j > -1 && current < array[j]; --j) {
                array[j + 1] = array[j];
            }
            array[j + 1] = current;
        }
    }

    public static Method findMethod(Class<?> cls, String attr, Class<?>[] paramTypes) {
        String methodName;
        String[] methodNames;
        if (attr == null || "".equals(attr)) {
            return null;
        }
        String firstUpper = String.valueOf(attr.charAt(0)).toUpperCase(Locale.ENGLISH) + attr.substring(1);
        Method[] methods = cls.getMethods();
        Method finalMethod = null;
        String[] stringArray = methodNames = new String[]{attr, "get" + firstUpper, "is" + firstUpper};
        int n = stringArray.length;
        for (int i = 0; i < n && (finalMethod = ReflectUtil.match(methodName = stringArray[i], paramTypes, methods)) == null; ++i) {
        }
        return finalMethod;
    }

    public static Method getMethod(Class<?> cls, String methodName, Class<?>[] paramTypes) {
        Method[] methods = cls.getMethods();
        return ReflectUtil.match(methodName, paramTypes, methods);
    }

    private static Method match(String methodName, Class<?>[] paramValueTypes, Method[] methods) {
        Method finalMethod = null;
        Method nameParamLengthEqualsMethod = null;
        block0: for (Method m : methods) {
            String name = m.getName();
            if (!name.equals(methodName)) continue;
            Object[] methodParamTypes = m.getParameterTypes();
            if (methodParamTypes != null && paramValueTypes != null) {
                if (methodParamTypes.length != paramValueTypes.length) continue;
                if (nameParamLengthEqualsMethod == null) {
                    nameParamLengthEqualsMethod = m;
                }
                for (int i = 0; i < methodParamTypes.length; ++i) {
                    Object c1 = methodParamTypes[i];
                    Class<?> c2 = paramValueTypes[i];
                    if (!ReflectUtil.isTypeMatch(c1, c2)) continue block0;
                }
                finalMethod = m;
                break;
            }
            if (!ArrayUtils.isEmpty(methodParamTypes) || !ArrayUtils.isEmpty(paramValueTypes)) continue;
            finalMethod = m;
            break;
        }
        return finalMethod == null ? nameParamLengthEqualsMethod : finalMethod;
    }

    public static boolean isTypeMatch(Class<?> c1, Class<?> c2) {
        if (c1 == c2 || c2 == Null.class) {
            return true;
        }
        Class<?> w1 = ReflectUtil.toWrapperClass(c1);
        Class<?> w2 = ReflectUtil.toWrapperClass(c2);
        if (w1 != null && w1 == w2) {
            return true;
        }
        return c1.isAssignableFrom(c2);
    }

    public static String getClassName(Class<?> cls) {
        if (cls == null) {
            return "null";
        }
        return cls.getCanonicalName();
    }

    static {
        numberClassMap = ReflectUtil.wrapperNumberCls();
        primitiveCls = new HashMap(ReflectUtil.primitiveNumberCls());
        primitiveCls.put(Boolean.TYPE, Boolean.TYPE);
        primitiveCls.put(Boolean.class, Boolean.TYPE);
        wrapperCls = new HashMap(ReflectUtil.wrapperNumberCls());
        wrapperCls.put(Boolean.TYPE, Boolean.class);
        wrapperCls.put(Boolean.class, Boolean.class);
    }
}

