/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.compile;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.fel.Expression;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.fel.compile.CompileService;
import kd.fi.bcm.fel.compile.FelCompiler;
import kd.fi.bcm.fel.compile.FileClassLoader;
import kd.fi.bcm.fel.compile.JavaSource;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstCompiler
implements FelCompiler {
    private static final String CLASS_DIR;
    private String classpath4compile = this.classPathToString();
    private static final String BASE_DIR;
    private static ClassLoader loader;
    private static ExecutorService exeService;

    static String getClassPackageDir(String pack) {
        return CLASS_DIR + AbstCompiler.packageToPath(pack) + File.separator;
    }

    protected final String classPathToString() {
        List<String> paths = CompileService.getClassPath(this.getClass().getClassLoader());
        StringBuilder cpStr = new StringBuilder();
        for (String c : paths) {
            cpStr.append(c).append(File.pathSeparator);
        }
        return cpStr.toString();
    }

    static String getSrcPackageDir(String pack) {
        return BASE_DIR + "src" + File.separator + AbstCompiler.packageToPath(pack) + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression compile(JavaSource src) {
        try {
            Class<Expression> compile = this.compileToClass(src);
            Expression expression = compile.getConstructor(new Class[0]).newInstance(new Object[0]);
            return expression;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Expression expression = null;
            return expression;
        }
        finally {
            String className = src.getName();
            String pack = src.getPackageName();
            String srcPackageDir = AbstCompiler.getSrcPackageDir(pack);
            this.clean(srcPackageDir, AbstCompiler.getClassPackageDir(pack), className);
        }
    }

    abstract Class<Expression> compileToClass(JavaSource var1) throws ClassNotFoundException;

    static void createClassDir() {
        new File(FilenameUtils.getName((String)CLASS_DIR)).mkdirs();
    }

    private static ExecutorService initThreadPool() {
        return new ThreadPoolExecutor(0, 10, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    void clean(final String srcPackageDir, final String classPackageDir, final String fileName) {
        if (exeService.isShutdown()) {
            exeService = AbstCompiler.initThreadPool();
        }
        exeService.execute(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(1);
                AbstCompiler.this.delFile(srcPackageDir, classPackageDir, fileName);
            }
        });
    }

    void delFile(String srcPackageDir, String classPackageDir, String fileName) {
        String src = srcPackageDir + fileName + ".java";
        this.deleteFile(src);
        String cls = classPackageDir + fileName + ".class";
        this.deleteFile(cls);
    }

    void deleteFile(String src) {
        File file = new File(FilenameUtils.getName((String)src));
        if (file.exists() && !file.delete()) {
            throw new KDBizException(String.format("delete file error :%s", file.getPath()));
        }
    }

    List<String> getCompileOption() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-encoding");
        options.add("UTF-8");
        options.add("-d");
        options.add(CLASS_DIR);
        if (StringUtils.isNotEmpty(this.classpath4compile)) {
            options.add("-classpath");
            options.add(this.classpath4compile);
        }
        return options;
    }

    private static String packageToPath(String packageName) {
        String sep = File.separator;
        return StringUtils.replace(packageName, ".", sep);
    }

    static {
        String userDir = System.getProperty("user.dir");
        BASE_DIR = userDir + File.separator + "fel" + File.separator;
        CLASS_DIR = BASE_DIR + "classes" + File.separator;
        loader = new FileClassLoader(AbstCompiler.class.getClassLoader(), CLASS_DIR);
        AbstCompiler.createClassDir();
        exeService = AbstCompiler.initThreadPool();
    }
}

