/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.compile;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import kd.fi.bcm.common.cache.LocalCacheHelper;
import kd.fi.bcm.fel.Expression;
import kd.fi.bcm.fel.compile.ConstExpSrc;
import kd.fi.bcm.fel.compile.FelCompiler;
import kd.fi.bcm.fel.compile.JavaSource;
import kd.fi.bcm.fel.compile.SourceGenerator;
import kd.fi.bcm.fel.compile.SourceGeneratorImpl;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.parser.FelNode;

public class CompileService {
    private SourceGenerator srcGen = new SourceGeneratorImpl();
    private FelCompiler complier = this.newCompiler(this.getCompilerClassName());

    public SourceGenerator getSrcGen() {
        return this.srcGen;
    }

    public void setSrcGen(SourceGenerator srcGen) {
        this.srcGen = srcGen;
    }

    public FelCompiler getComplier() {
        return this.complier;
    }

    public void setComplier(FelCompiler complier) {
        this.complier = complier;
    }

    public static List<String> getClassPath(ClassLoader cl) {
        ArrayList<String> paths = new ArrayList<String>();
        while (cl != null) {
            boolean isUrlClassloader = cl instanceof URLClassLoader;
            if (isUrlClassloader) {
                URLClassLoader urlClassLoader = (URLClassLoader)cl;
                for (URL url : urlClassLoader.getURLs()) {
                    paths.add(url.getFile());
                }
            } else {
                Enumeration<URL> resources = null;
                try {
                    resources = cl.getResources("/");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (resources != null) {
                    while (resources.hasMoreElements()) {
                        URL resource = resources.nextElement();
                        paths.add(resource.getFile());
                    }
                }
            }
            cl = cl.getParent();
        }
        return paths;
    }

    private FelCompiler newCompiler(String name) {
        FelCompiler comp = null;
        try {
            Class<?> cls = Class.forName(name);
            String key = this.getClass().getSimpleName() + "_newCompiler_" + name;
            comp = LocalCacheHelper.get(key, FelCompiler.class);
            if (comp == null) {
                comp = (FelCompiler)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                LocalCacheHelper.put(key, comp);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return comp;
    }

    private String getCompilerClassName() {
        String version = System.getProperty("java.version");
        String compileClassName = FelCompiler.class.getName();
        compileClassName = version != null && version.startsWith("1.5") ? compileClassName + "15" : compileClassName + "16";
        return compileClassName;
    }

    public Expression compile(FelContext ctx, FelNode node, String originalExp) {
        try {
            JavaSource src = this.srcGen.getSource(ctx, node);
            if (src instanceof ConstExpSrc) {
                ConstExpSrc s = (ConstExpSrc)src;
                return s.getValue();
            }
            src.setSource("// \u8868\u8fbe\u5f0f:" + originalExp + "\n" + src.getSource());
            return this.complier.compile(src);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

