/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.compile;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import kd.fi.bcm.fel.Expression;
import kd.fi.bcm.fel.compile.CompileService;
import kd.fi.bcm.fel.compile.FelCompiler;
import kd.fi.bcm.fel.compile.FelCompilerClassloader;
import kd.fi.bcm.fel.compile.FelJavaFileObject;
import kd.fi.bcm.fel.compile.JavaSource;
import kd.fi.bcm.fel.exception.CompileException;
import org.apache.commons.io.FilenameUtils;

public class FelCompiler16<T>
implements FelCompiler {
    private final FelCompilerClassloader classLoader;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final List<String> options;
    private DiagnosticCollector<JavaFileObject> diagnostics;
    private final JavaFileManager javaFileManager;

    public FelCompiler16() {
        if (this.compiler == null) {
            throw new IllegalStateException("Cannot find the system Java compiler. Check that your class path includes tools.jar");
        }
        this.classLoader = new FelCompilerClassloader(this.getClass().getClassLoader());
        this.diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(this.diagnostics, null, null);
        ClassLoader loader = this.classLoader.getParent();
        List<String> paths = CompileService.getClassPath(loader);
        ArrayList<File> cpFiles = new ArrayList<File>();
        if (paths != null && !paths.isEmpty()) {
            for (String file : paths) {
                cpFiles.add(new File(FilenameUtils.getName((String)file)));
            }
        }
        try {
            fileManager.setLocation(StandardLocation.CLASS_PATH, cpFiles);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.javaFileManager = new ForwardingJavaFileManager<JavaFileManager>((JavaFileManager)fileManager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedName, JavaFileObject.Kind kind, FileObject outputFile) throws IOException {
                FelCompiler16.this.classLoader.add(qualifiedName, outputFile);
                return (JavaFileObject)outputFile;
            }
        };
        this.options = this.options();
    }

    private List<String> options() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-classpath");
        StringBuilder builder = new StringBuilder();
        String cp = System.getProperty("java.class.path");
        if (null != cp) {
            builder.append(cp).append(File.pathSeparator);
        }
        if (null != (cp = System.getProperty("sun.boot.class.path", ""))) {
            builder.append(cp).append(File.pathSeparator);
        }
        int lastIndexOfColon = builder.lastIndexOf(File.pathSeparator);
        builder.replace(lastIndexOfColon, lastIndexOfColon + 1, "");
        options.add(builder.toString());
        return options;
    }

    @Override
    public Expression compile(JavaSource src) {
        Class<T> compile = this.compileToClass(src);
        try {
            return (Expression)compile.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    public synchronized Class<T> compileToClass(JavaSource src) {
        ArrayList<FelJavaFileObject> compileSrcs = new ArrayList<FelJavaFileObject>();
        String className = src.getSimpleName();
        FelJavaFileObject compileSrc = new FelJavaFileObject(className, src.getSource());
        compileSrcs.add(compileSrc);
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.javaFileManager, this.diagnostics, this.options, null, compileSrcs);
        Boolean result = task.call();
        if (result == null || !result.booleanValue()) {
            throw new CompileException(src.getSource() + "\n" + this.diagnostics.getDiagnostics());
        }
        try {
            return this.loadClass(src.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Class<T> loadClass(String qualifiedClassName) throws ClassNotFoundException {
        return this.classLoader.loadClass(qualifiedClassName);
    }

    static URI toUri(String name) {
        try {
            return new URI(name);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

