/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.compile;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.FilenameUtils;

public class FileClassLoader
extends ClassLoader {
    private static final Log logger = LogFactory.getLog(FileClassLoader.class);
    private String dir;
    public static final String fileType = ".class";

    public FileClassLoader(ClassLoader arg0, String dir) {
        super(arg0);
        this.dir = dir;
    }

    @Override
    public Class<?> findClass(String name) {
        byte[] data = this.loadClassData(name);
        return this.defineClass(name, data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadClassData(String name) {
        name = name.replaceAll("\\.", "/");
        FileInputStream fis = null;
        byte[] data = null;
        try {
            fis = new FileInputStream(new File(FilenameUtils.getName((String)(this.dir + name + fileType))));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int ch = 0;
            while ((ch = fis.read()) != -1) {
                baos.write(ch);
            }
            data = baos.toByteArray();
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        return data;
    }
}

