/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.compile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.fi.bcm.fel.common.Callable;
import kd.fi.bcm.fel.common.ReflectUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.fel.compile.ConstExpSrc;
import kd.fi.bcm.fel.compile.JavaSource;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.compile.SourceGenerator;
import kd.fi.bcm.fel.compile.VarBuffer;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.optimizer.ConstExpOpti;
import kd.fi.bcm.fel.optimizer.ConstOpti;
import kd.fi.bcm.fel.optimizer.Optimizer;
import kd.fi.bcm.fel.parser.AbstFelNode;
import kd.fi.bcm.fel.parser.ConstNode;
import kd.fi.bcm.fel.parser.FelNode;
import kd.fi.bcm.fel.parser.VarAstNode;

public class SourceGeneratorImpl
implements SourceGenerator {
    private List<Optimizer> opt = new CopyOnWriteArrayList<Optimizer>();
    private static String template;
    private static int count;
    private Map<String, StringKeyValue> localvars = new ConcurrentHashMap<String, StringKeyValue>();
    private static final String PACKAGE;
    public static final Callable<Boolean, FelNode> varsFilter;

    public SourceGeneratorImpl() {
        ConstOpti constOpti = new ConstOpti();
        this.addOpti(constOpti);
        ConstExpOpti constExpOpti = new ConstExpOpti();
        this.addOpti(constExpOpti);
        Optimizer optimizVars = this.getVarOpti();
        this.addOpti(optimizVars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaSource getSource(FelContext ctx, FelNode node) {
        String src = "";
        String className = this.getClassName();
        SourceGeneratorImpl sourceGeneratorImpl = this;
        synchronized (sourceGeneratorImpl) {
            node = this.optimize(ctx, node);
            if (node instanceof ConstNode) {
                ConstNode n = (ConstNode)node;
                return new ConstExpSrc(n.interpret(null, null));
            }
            SourceBuilder builder = node.toMethod(ctx);
            String exp = builder.source(ctx, node);
            src = this.buildsource(exp, className);
            this.localvars.clear();
        }
        JavaSource returnMe = new JavaSource();
        returnMe.setSimpleName(className);
        returnMe.setSource(src);
        returnMe.setPackageName(PACKAGE);
        return returnMe;
    }

    private String buildsource(String expression, String className) {
        String src = StringUtils.replace(template, "${classname}", className);
        StringBuilder attrs = new StringBuilder();
        String pop = VarBuffer.pop();
        if (pop != null) {
            attrs.append(pop).append("\r\n");
            pop = VarBuffer.pop();
        }
        while (pop != null) {
            attrs.append("    ").append(pop).append("\r\n");
            pop = VarBuffer.pop();
        }
        src = StringUtils.replace(src, "${attrs}", attrs.toString());
        src = StringUtils.replace(src, "${localVars}", this.getLocalVarsCode());
        src = StringUtils.replace(src, "${expression}", expression);
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getClassName() {
        String className = null;
        Class<SourceGeneratorImpl> clazz = SourceGeneratorImpl.class;
        synchronized (SourceGeneratorImpl.class) {
            className = "Fel_" + count++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return className;
        }
    }

    private String getLocalVarsCode() {
        StringBuilder sb = new StringBuilder();
        Collection<StringKeyValue> values = this.localvars.values();
        boolean isFirst = true;
        for (StringKeyValue code : values) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("        ");
            }
            sb.append(code.value).append("\r\n");
        }
        this.removeLastEnter(sb);
        return sb.toString();
    }

    private void removeLastEnter(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
    }

    private FelNode optimize(FelContext ctx, FelNode node) {
        for (Optimizer o : this.opt) {
            node = o.call(ctx, node);
        }
        return node;
    }

    private Optimizer getVarOpti() {
        Optimizer optimizVars = new Optimizer(){

            @Override
            public FelNode call(FelContext ctx, FelNode node) {
                List<FelNode> nodes = AbstFelNode.getNodes(node, varsFilter);
                HashMap<String, ArrayList<FelNode>> repeatNodeMap = new HashMap<String, ArrayList<FelNode>>();
                for (FelNode n : nodes) {
                    String name = n.getText();
                    ArrayList<FelNode> repeatNodes = (ArrayList<FelNode>)repeatNodeMap.get(name);
                    if (repeatNodes == null) {
                        repeatNodes = new ArrayList<FelNode>();
                        repeatNodeMap.put(name, repeatNodes);
                    }
                    repeatNodes.add(n);
                }
                for (List repeatNodes : repeatNodeMap.values()) {
                    if (repeatNodes.size() <= 1) continue;
                    for (FelNode n : repeatNodes) {
                        n.setSourcebuilder(this.getVarSrcBuilder(n.toMethod(ctx)));
                    }
                }
                return node;
            }

            private void setVarSourceBuilder(FelContext ctx, FelNode node) {
                if (node instanceof VarAstNode) {
                    node.setSourcebuilder(this.getVarSrcBuilder(node.toMethod(ctx)));
                } else {
                    List<FelNode> children = node.getChildren();
                    if (children != null && !children.isEmpty()) {
                        for (FelNode child : children) {
                            this.setVarSourceBuilder(ctx, child);
                        }
                    }
                }
            }

            private SourceBuilder getVarSrcBuilder(final SourceBuilder old) {
                return new SourceBuilder(){

                    @Override
                    public String source(FelContext ctx, FelNode node) {
                        String text = node.getText();
                        if (SourceGeneratorImpl.this.localvars.containsKey(text)) {
                            StringKeyValue kv = (StringKeyValue)SourceGeneratorImpl.this.localvars.get(text);
                            return kv.key;
                        }
                        String varName = text;
                        Class<?> type = this.returnType(ctx, node);
                        String declare = "";
                        String typeDeclare = type.getCanonicalName();
                        if (ReflectUtil.isPrimitiveOrWrapNumber(type)) {
                            Class<?> primitiveClass = ReflectUtil.toPrimitiveClass(type);
                            typeDeclare = primitiveClass.getSimpleName();
                        } else if (Number.class.isAssignableFrom(type)) {
                            typeDeclare = "double";
                        }
                        declare = typeDeclare + " " + varName + " = " + old.source(ctx, node) + ";   //" + text;
                        StringKeyValue kv = new StringKeyValue(varName, declare);
                        SourceGeneratorImpl.this.localvars.put(text, kv);
                        return varName;
                    }

                    @Override
                    public Class<?> returnType(FelContext ctx, FelNode n) {
                        return old.returnType(ctx, n);
                    }
                };
            }
        };
        return optimizVars;
    }

    @Override
    public final void addOpti(Optimizer opti) {
        this.opt.add(opti);
    }

    static {
        count = 0;
        String fullName = SourceGeneratorImpl.class.getName();
        PACKAGE = fullName.substring(0, fullName.lastIndexOf(46));
        StringBuilder sb = new StringBuilder();
        try (InputStream in = SourceGeneratorImpl.class.getClassLoader().getResourceAsStream("fel/java.template");
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        template = sb.toString();
        varsFilter = new Callable<Boolean, FelNode>(){

            public Boolean call(FelNode ... node) {
                FelNode n = node[0];
                return VarAstNode.isVar(n);
            }
        };
    }

    static class StringKeyValue {
        private String key;
        private String value;

        public StringKeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

