/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.context;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.fi.bcm.fel.context.ArrayCtx;
import kd.fi.bcm.fel.context.Var;

public class ArrayCtxImpl
implements ArrayCtx {
    private Var[] vars = new Var[10];
    private Map<String, Integer> indexMap = new HashMap<String, Integer>();

    public ArrayCtxImpl() {
    }

    public ArrayCtxImpl(Map<String, Object> vars) {
        if (vars != null) {
            for (Map.Entry<String, Object> e : vars.entrySet()) {
                this.set(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public Object get(int i) {
        return this.vars[i].getValue();
    }

    @Override
    public int getIndex(String name) {
        Integer i = this.indexMap.get(name);
        return i != null ? i : -1;
    }

    @Override
    public Object get(String name) {
        Var var = this.getVar(name);
        return var != null ? var.getValue() : null;
    }

    @Override
    public Var getVar(String name) {
        int index = this.getIndex(name);
        if (index == -1) {
            return null;
        }
        return this.vars[index];
    }

    private Var getVarWithoutNull(String name) {
        Var var = this.getVar(name);
        if (var == null) {
            var = new Var(name, null);
            this.setVar(var);
        }
        return var;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.vars.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.vars = Arrays.copyOf(this.vars, newCapacity);
        }
    }

    @Override
    public final void set(String name, Object value) {
        this.getVarWithoutNull(name).setValue(value);
    }

    @Override
    public void setVar(Var var) {
        int i = this.addToIndexMap(var.getName());
        if (i >= this.vars.length) {
            this.ensureCapacity(i + 1);
        }
        this.vars[i] = var;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addToIndexMap(String name) {
        Map<String, Integer> map = this.indexMap;
        synchronized (map) {
            Integer i = this.indexMap.get(name);
            if (i != null) {
                return i;
            }
            int newIndex = this.indexMap.size();
            this.indexMap.put(name, newIndex);
            return newIndex;
        }
    }
}

