/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function;

import java.lang.reflect.InvocationTargetException;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.fel.compile.FelMethod;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.function.Function;
import kd.fi.bcm.fel.parser.FelNode;

public class Dollar
implements Function {
    private static final String suffix = ".new";

    @Override
    public String getName() {
        return "$";
    }

    @Override
    public Object call(FelNode node, FelContext context) {
        String txt = this.getChildText(node);
        boolean isNew = this.isNew(txt);
        Class<?> cls = this.getClass(txt, isNew);
        if (isNew) {
            return this.newObject(cls);
        }
        return cls;
    }

    private Object newObject(Class<?> cls) {
        Object o = null;
        if (cls != null) {
            try {
                o = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return o;
    }

    private Class<?> getClass(String txt, boolean isNew) {
        String className = txt;
        if (isNew) {
            className = className.substring(0, txt.length() - suffix.length());
        }
        if (className.indexOf(46) == -1) {
            className = "java.lang." + className;
        }
        try {
            Class<?> clz = Class.forName(className);
            return clz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private boolean isNew(String txt) {
        boolean isNew = txt.endsWith(suffix);
        return isNew;
    }

    private String getChildText(FelNode node) {
        String txt = node.getChildren().get(0).getText();
        txt = StringUtils.remove(txt, '\'');
        txt = StringUtils.remove(txt, '\"');
        return txt;
    }

    @Override
    public SourceBuilder toMethod(FelNode node, FelContext ctx) {
        boolean isNew;
        String txt = this.getChildText(node);
        Class<?> cls = this.getClass(txt, isNew = this.isNew(txt));
        if (cls == null) {
            return null;
        }
        String code = cls.getName();
        if (isNew) {
            code = "new " + code + "()";
        }
        return new FelMethod(cls, code);
    }
}

