/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.fel.function.Dollar;
import kd.fi.bcm.fel.function.Function;
import kd.fi.bcm.fel.function.operator.Add;
import kd.fi.bcm.fel.function.operator.And;
import kd.fi.bcm.fel.function.operator.CollectionGet;
import kd.fi.bcm.fel.function.operator.Cond;
import kd.fi.bcm.fel.function.operator.Div;
import kd.fi.bcm.fel.function.operator.Dot;
import kd.fi.bcm.fel.function.operator.Equal;
import kd.fi.bcm.fel.function.operator.GreaterThan;
import kd.fi.bcm.fel.function.operator.GreaterThenEqual;
import kd.fi.bcm.fel.function.operator.LessThen;
import kd.fi.bcm.fel.function.operator.LessThenEqual;
import kd.fi.bcm.fel.function.operator.Mod;
import kd.fi.bcm.fel.function.operator.Mul;
import kd.fi.bcm.fel.function.operator.NotEqual;
import kd.fi.bcm.fel.function.operator.NotOper;
import kd.fi.bcm.fel.function.operator.Or;
import kd.fi.bcm.fel.function.operator.Sub;

public class FunMgr {
    private final Map<String, Function> userFunMap;
    private Map<String, Function> funcMap = new HashMap<String, Function>();

    public FunMgr() {
        this.addFun(new Dot());
        this.addFun(new CollectionGet());
        this.addFun(new Cond());
        this.addFun(new Dollar());
        this.addFun(new NotOper());
        this.addFun(new Add());
        this.addFun(new Sub());
        this.addFun(new Equal());
        this.addFun(new NotEqual());
        this.addFun(new Mul());
        this.addFun(new Div());
        this.addFun(new Mod());
        this.addFun(new LessThen());
        this.addFun(new LessThenEqual());
        this.addFun(new GreaterThan());
        this.addFun(new GreaterThenEqual());
        this.addFun(new And());
        this.addFun(new Or());
        this.userFunMap = new HashMap<String, Function>();
    }

    public void autoLoad() {
        try {
            Enumeration<URL> res = this.getClass().getClassLoader().getResources("com/greenpineyu/fel/function/");
            while (res.hasMoreElements()) {
                URL uRL = res.nextElement();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addFun(Function fun) {
        this.funcMap.put(fun.getName(), fun);
    }

    public Function getFun(String funName) {
        if (funName != null) {
            String newFunName;
            Function userFun;
            if ("IF".equalsIgnoreCase(funName)) {
                funName = "?";
            }
            if ((userFun = this.userFunMap.get(newFunName = this.getLowerCaseName(funName))) != null) {
                return userFun;
            }
            return this.funcMap.get(newFunName);
        }
        return null;
    }

    private String getLowerCaseName(String funName) {
        return funName.toLowerCase(Locale.ENGLISH);
    }

    public void add(Function fun) {
        if (fun == null) {
            return;
        }
        String name = fun.getName();
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u51fd\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FunMgr_0", (String)"fi-bcm-common", (Object[])new Object[0]));
        }
        this.userFunMap.put(this.getLowerCaseName(name), fun);
    }

    public void remove(String name) {
        if (name != null) {
            this.userFunMap.remove(this.getLowerCaseName(name));
        }
    }
}

