/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function;

import java.lang.reflect.Method;
import java.util.List;
import kd.fi.bcm.fel.compile.FelMethod;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.compile.VarBuffer;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.function.CommonFunction;
import kd.fi.bcm.fel.function.Function;
import kd.fi.bcm.fel.function.operator.Dot;
import kd.fi.bcm.fel.parser.FelNode;

public class JavaMethod
implements Function {
    private String name;
    private Object obj;
    private Method method;

    public JavaMethod(String name, Method method, Object obj) {
        this.name = name;
        this.method = method;
        this.obj = obj;
    }

    @Override
    public Object call(FelNode node, FelContext context) {
        Object[] args = CommonFunction.evalArgs(node, context);
        return Dot.invoke(this.obj, this.method, args);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SourceBuilder toMethod(FelNode node, FelContext context) {
        StringBuilder code = new StringBuilder();
        String classOrObjCode = this.getClassOrObjCode();
        code.append(classOrObjCode);
        code.append('.');
        String methodName = this.method.getName();
        code.append(methodName);
        StringBuilder methodParams = this.getParamsCode(node, context);
        code.append('(').append((CharSequence)methodParams).append(')');
        FelMethod returnMe = new FelMethod(this.method.getReturnType(), code.toString());
        return returnMe;
    }

    private String getClassOrObjCode() {
        if (this.obj == null) {
            Class<?> cls = this.method.getDeclaringClass();
            return cls.getCanonicalName();
        }
        String varName = VarBuffer.push(this.obj);
        return varName;
    }

    private StringBuilder getParamsCode(FelNode node, FelContext context) {
        StringBuilder methodParams = new StringBuilder();
        List<FelNode> params = node.getChildren();
        boolean hasParam = params != null && !params.isEmpty();
        Class<?>[] paramTypes = this.method.getParameterTypes();
        if (hasParam) {
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> paramType = paramTypes[i];
                FelNode p = params.get(i);
                String paramCode = Dot.getParamCode(paramType, p, context);
                methodParams.append(paramCode);
                if (i >= paramTypes.length - 1) continue;
                methodParams.append(',');
            }
        }
        return methodParams;
    }
}

