/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function.operator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.fel.common.ObjectUtils;
import kd.fi.bcm.fel.common.ReflectUtil;
import kd.fi.bcm.fel.compile.FelMethod;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.function.StableFunction;
import kd.fi.bcm.fel.function.TolerantFunction;
import kd.fi.bcm.fel.parser.FelNode;

public class Add
extends StableFunction {
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    @Override
    public Object call(FelNode node, FelContext context) {
        Object returnMe = null;
        for (FelNode felNode : node.getChildren()) {
            Object r;
            Object object = TolerantFunction.eval(context, felNode);
            if (object instanceof String) {
                if (returnMe == null) {
                    returnMe = object;
                    continue;
                }
                returnMe = returnMe + (String)object;
            }
            if (!(object instanceof Number)) continue;
            if (returnMe == null) {
                returnMe = object;
                continue;
            }
            Number value = (Number)object;
            if (returnMe instanceof Number) {
                r = (Number)returnMe;
                returnMe = NumberUtil.toDouble((Number)r) + NumberUtil.toDouble(value);
                continue;
            }
            if (!(returnMe instanceof String)) continue;
            r = (String)returnMe;
            returnMe = (String)r + value;
        }
        if (returnMe instanceof Number) {
            return NumberUtil.parseNumber(returnMe.toString());
        }
        return returnMe;
    }

    @Override
    public String getName() {
        return "+";
    }

    @Override
    public FelMethod toMethod(FelNode node, FelContext ctx) {
        Class<Object> type = null;
        List<FelNode> children = node.getChildren();
        StringBuilder sb = new StringBuilder();
        if (children.size() == 2) {
            FelNode left = children.get(0);
            SourceBuilder lm = left.toMethod(ctx);
            this.appendArg(sb, lm, ctx, left);
            Class<?> leftType = lm.returnType(ctx, left);
            FelNode right = children.get(1);
            sb.append('+');
            SourceBuilder rm = right.toMethod(ctx);
            Class<?> rightType = rm.returnType(ctx, right);
            type = CharSequence.class.isAssignableFrom(leftType) ? leftType : (CharSequence.class.isAssignableFrom(rightType) ? rightType : (ReflectUtil.isPrimitiveOrWrapNumber(leftType) && ReflectUtil.isPrimitiveOrWrapNumber(rightType) ? NumberUtil.arithmeticClass(leftType, rightType) : String.class));
            this.appendArg(sb, rm, ctx, right);
        } else if (children.size() == 1) {
            FelNode right = children.get(0);
            SourceBuilder rm = right.toMethod(ctx);
            Class<?> rightType = rm.returnType(ctx, right);
            if (ReflectUtil.isPrimitiveOrWrapNumber(rightType)) {
                this.appendArg(sb, rm, ctx, right);
            }
            type = rightType;
        }
        FelMethod m = new FelMethod(type, sb.toString());
        return m;
    }

    private void appendArg(StringBuilder sb, SourceBuilder argMethod, FelContext ctx, FelNode node) {
        Class<?> t = argMethod.returnType(ctx, node);
        sb.append('(');
        if (ReflectUtil.isPrimitiveOrWrapNumber(t) || CharSequence.class.isAssignableFrom(t)) {
            sb.append(argMethod.source(ctx, node));
        } else {
            sb.append("ObjectUtils.toString(").append(argMethod.source(ctx, node)).append(')');
        }
        sb.append(')');
    }

    public static Object add(Object left, Object right) {
        if (left == null || right == null) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u8c03\u7528add()\u65b9\u6cd5\u51fa\u9519\u3002\u539f\u56e0\uff1a\u5f53\u524d\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"Add_0", (String)"fi-bcm-common", (Object[])new Object[0]));
        }
        try {
            if (left instanceof Object[]) {
                left = NumberUtil.calArray(left);
            }
            if (right instanceof Object[]) {
                right = NumberUtil.calArray(right);
            }
            if (NumberUtil.isFloatingPointNumber(left) || NumberUtil.isFloatingPointNumber(right)) {
                double l = NumberUtil.toDouble(left);
                double r = NumberUtil.toDouble(right);
                return l + r;
            }
            if (left instanceof BigInteger && right instanceof BigInteger) {
                BigInteger l = NumberUtil.toBigInteger(left);
                BigInteger r = NumberUtil.toBigInteger(right);
                return l.add(r);
            }
            if (left instanceof BigDecimal || right instanceof BigDecimal) {
                BigDecimal l = NumberUtil.toBigDecimal(left);
                BigDecimal r = NumberUtil.toBigDecimal(right);
                return l.add(r);
            }
            if (left instanceof String && right instanceof Date) {
                Instant instant = ((Date)right).toInstant();
                ZoneId zone = ZoneId.systemDefault();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
                String nowStr = localDateTime.format(DATE_FORMAT);
                return left + nowStr;
            }
            if (left instanceof Date && right instanceof String) {
                Instant instant = ((Date)left).toInstant();
                ZoneId zone = ZoneId.systemDefault();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
                String nowStr = localDateTime.format(DATE_FORMAT);
                return nowStr + right;
            }
            BigInteger l = NumberUtil.toBigInteger(left);
            BigInteger r = NumberUtil.toBigInteger(right);
            BigInteger result = l.add(r);
            return NumberUtil.narrowBigInteger(left, right, result);
        }
        catch (Exception e) {
            return ObjectUtils.toString(left).concat(ObjectUtils.toString(right));
        }
    }
}

